/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.emf.ecoretools.ale.core.parser.ALELexer;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.IOUtils;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.parser.internal.AntlrAstToBehaviorsAstAdapter;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class BehaviorsParser {
    private IQueryEnvironment queryEnvironment;
    private ResourceSet rs;

    public BehaviorsParser(IQueryEnvironment qryEnv) {
        this.queryEnvironment = qryEnv;
        this.rs = new ResourceSetImpl();
    }

    public BehaviorsParser(IQueryEnvironment qryEnv, ResourceSet rs) {
        this.queryEnvironment = qryEnv;
        this.rs = rs;
    }

    public List<ParsedFile<ModelUnit>> parse(List<EPackage> metamodels, Set<String> behaviorsSourcesPaths) {
        this.cleanUp();
        this.register(metamodels);
        return this.parseFromFiles(IOUtils.toAbsolutePaths(behaviorsSourcesPaths));
    }

    public List<ParsedFile<ModelUnit>> parse(List<EPackage> context, List<InputStream> behaviorsContents) {
        this.cleanUp();
        this.register(context);
        return this.parseFromInputStreams(behaviorsContents);
    }

    private void cleanUp() {
        List<EPackage> toRemove = this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().stream().filter(p -> p.getNsURI().startsWith("http://ale/runtime/")).collect(Collectors.toList());
        toRemove.forEach(p -> this.queryEnvironment.removeEPackage(p));
    }

    private void register(Collection<EPackage> packages) {
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMIResourceFactoryImpl());
        for (EPackage pkg : packages) {
            boolean metamodelAlreadyInRegistry;
            EPackage registryPkg = this.rs.getPackageRegistry().getEPackage(pkg.getNsURI());
            boolean bl = metamodelAlreadyInRegistry = registryPkg != null;
            if (metamodelAlreadyInRegistry) {
                this.register(registryPkg);
                continue;
            }
            this.register(pkg);
        }
    }

    private void register(EPackage pkg) {
        Collection matchingPkgs = this.queryEnvironment.getEPackageProvider().getEPackage(pkg.getName());
        Optional<EPackage> existingPkg = matchingPkgs.stream().filter(p -> p.getNsURI().equals(pkg.getNsURI())).findFirst();
        if (!existingPkg.isPresent()) {
            this.queryEnvironment.registerEPackage(pkg);
        }
    }

    public List<ParsedFile<ModelUnit>> parseFromInputStreams(List<InputStream> inputs) {
        ArrayList<ALEParser.RRootContext> rawASTs = new ArrayList<ALEParser.RRootContext>();
        inputs.forEach(input -> this.doParse((InputStream)input).ifPresent(rawASTs::add));
        AntlrAstToBehaviorsAstAdapter adapter = new AntlrAstToBehaviorsAstAdapter(this.queryEnvironment);
        return adapter.toBehaviors(rawASTs, new HashMap<ALEParser.RRootContext, String>());
    }

    public List<ParsedFile<ModelUnit>> parseFromFiles(Collection<String> paths) {
        ArrayList<ALEParser.RRootContext> rawASTs = new ArrayList<ALEParser.RRootContext>();
        HashMap<ALEParser.RRootContext, String> sourceFiles = new HashMap<ALEParser.RRootContext, String>();
        for (String path : paths) {
            this.doParse(path).ifPresent(ast -> {
                rawASTs.add((ALEParser.RRootContext)((Object)ast));
                sourceFiles.put((ALEParser.RRootContext)((Object)ast), path);
            });
        }
        AntlrAstToBehaviorsAstAdapter adapter = new AntlrAstToBehaviorsAstAdapter(this.queryEnvironment);
        return adapter.toBehaviors(rawASTs, sourceFiles);
    }

    private Optional<ALEParser.RRootContext> doParse(InputStream fileContent) {
        try {
            ANTLRInputStream input = new ANTLRInputStream(fileContent);
            ALELexer lexer = new ALELexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ALEParser parser = new ALEParser((TokenStream)tokens);
            return Optional.of(parser.rRoot());
        }
        catch (IOException e) {
            Activator.error("ANTLR parser failed to parse ALE sources from given input stream", e);
            return Optional.empty();
        }
    }

    private Optional<ALEParser.RRootContext> doParse(String fileName) {
        try {
            ANTLRFileStream input = new ANTLRFileStream(fileName);
            ALELexer lexer = new ALELexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ALEParser parser = new ALEParser((TokenStream)tokens);
            return Optional.of(parser.rRoot());
        }
        catch (IOException e) {
            Activator.error("ANTLR parser failed to parse ALE sources from given input stream", e);
            return Optional.empty();
        }
    }
}

