/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.metamodel.melange.XbaseTransformation;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Compiles Melange's {@link Transformation}s
 */
@SuppressWarnings("all")
public class TransformationInferrer {
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  /**
   * Creates a Java class for the given {@code transfo} with a unique static
   * method "call" where the code of the transformation is compiled.
   * If the supplied {@link XbaseTransformation} is annotated with @Main,
   * also generates a {@code public static void main(String[] args)} method.
   */
  public void generateTransformation(final XbaseTransformation transfo, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Stopwatches.StoppedTask task = Stopwatches.forTask("generate transformations");
    task.start();
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        JvmTypeReference _elvis = null;
        JvmTypeReference _returnTypeRef = transfo.getReturnTypeRef();
        if (_returnTypeRef != null) {
          _elvis = _returnTypeRef;
        } else {
          JvmTypeReference _typeRef = builder.typeRef(Void.TYPE);
          _elvis = _typeRef;
        }
        final JvmTypeReference returnType = _elvis;
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            final Consumer<JvmFormalParameter> _function = new Consumer<JvmFormalParameter>() {
              @Override
              public void accept(final JvmFormalParameter p) {
                EList<JvmFormalParameter> _parameters = it.getParameters();
                JvmFormalParameter _parameter = TransformationInferrer.this._jvmTypesBuilder.toParameter(transfo, p.getName(), p.getParameterType());
                TransformationInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
              }
            };
            transfo.getParameters().forEach(_function);
            TransformationInferrer.this._jvmTypesBuilder.setBody(it, transfo.getBody());
          }
        };
        JvmOperation _method = TransformationInferrer.this._jvmTypesBuilder.toMethod(transfo, "call", returnType, _function);
        TransformationInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        boolean _isMain = transfo.isMain();
        if (_isMain) {
          EList<JvmMember> _members_1 = it.getMembers();
          final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              it.setStatic(true);
              EList<JvmFormalParameter> _parameters = it.getParameters();
              JvmFormalParameter _parameter = TransformationInferrer.this._jvmTypesBuilder.toParameter(transfo, "args", 
                TransformationInferrer.this._jvmTypesBuilder.addArrayTypeDimension(builder.typeRef(String.class)));
              TransformationInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("StandaloneSetup.doSetup() ;");
                  _builder.newLine();
                  _builder.append("call() ;");
                  _builder.newLine();
                }
              };
              TransformationInferrer.this._jvmTypesBuilder.setBody(it, _client);
            }
          };
          JvmOperation _method_1 = TransformationInferrer.this._jvmTypesBuilder.toMethod(transfo, "main", builder.typeRef(Void.TYPE), _function_1);
          TransformationInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
        }
      }
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toClass(transfo, this._namingHelper.getClassName(transfo)), _function);
    task.stop();
  }
}
