/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange;

import fr.inria.diverse.melange.AbstractMelangeRuntimeModule;
import fr.inria.diverse.melange.compiler.ModelOrientedXbaseCompiler;
import fr.inria.diverse.melange.resource.MelangeDerivedStateComputer;
import fr.inria.diverse.melange.typesystem.MelangeSynonymTypesProvider;
import fr.inria.diverse.melange.utils.MelangeQualifiedNameProvider;
import fr.inria.diverse.melange.validation.MelangeLocalResourceValidator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;

@SuppressWarnings("all")
public class MelangeRuntimeModule extends AbstractMelangeRuntimeModule {
  @Override
  public Class<? extends IDerivedStateComputer> bindIDerivedStateComputer() {
    return MelangeDerivedStateComputer.class;
  }
  
  public Class<? extends SynonymTypesProvider> bindSynonymTypesProvider() {
    return MelangeSynonymTypesProvider.class;
  }
  
  public Class<? extends XbaseCompiler> bindXbaseCompiler() {
    return ModelOrientedXbaseCompiler.class;
  }
  
  @Override
  public Class<? extends IResourceValidator> bindIResourceValidator() {
    return MelangeLocalResourceValidator.class;
  }
  
  @Override
  public Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
    return MelangeQualifiedNameProvider.class;
  }
  
  public Class<? extends IReferableElementsUnloader> bindIReferableElementsUnloader() {
    return IReferableElementsUnloader.NullUnloader.class;
  }
}
