/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p3order;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p3order.NodeRelativePortDistributor;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ListIterator;

public class InteractiveCrossingMinimizer
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(null, null, EnumSet.of(LayoutProcessorStrategy.LONG_EDGE_SPLITTER), EnumSet.of(LayoutProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR), null, EnumSet.of(LayoutProcessorStrategy.LONG_EDGE_JOINER));

    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Interactive crossing minimization", 1.0f);
        int portCount = 0;
        for (Layer layer : layeredGraph) {
            double horizPos = 0.0;
            int nodeCount = 0;
            for (LNode node : layer.getNodes()) {
                if (node.getPosition().x > 0.0) {
                    horizPos += node.getPosition().x + node.getSize().x / 2.0;
                    ++nodeCount;
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
            }
            horizPos /= (double)nodeCount;
            final double[] pos = new double[layer.getNodes().size()];
            int nextIndex = 0;
            for (LNode node : layer) {
                node.id = nextIndex++;
                pos[node.id] = this.getPos(node, horizPos, layeredGraph);
            }
            Collections.sort(layer.getNodes(), new Comparator<LNode>(){

                @Override
                public int compare(LNode node1, LNode node2) {
                    int compare = Double.compare(pos[node1.id], pos[node2.id]);
                    if (compare == 0) {
                        LNode node1Successor = (LNode)node1.getProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT);
                        LNode node2Successor = (LNode)node2.getProperty(Properties.IN_LAYER_SUCCESSOR_CONSTRAINT);
                        if (node1Successor == node2) {
                            return -1;
                        }
                        if (node2Successor == node1) {
                            return 1;
                        }
                    }
                    return compare;
                }
            });
        }
        LNode[][] lgraphArray = new LNode[layeredGraph.getLayers().size()][];
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            lgraphArray[layerIndex] = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
        }
        NodeRelativePortDistributor portDistributor = new NodeRelativePortDistributor(new float[portCount]);
        portDistributor.distributePorts(lgraphArray);
        this.getMonitor().done();
    }

    private double getPos(LNode node, double horizPos, LGraph graph) {
        switch ((NodeType)((Object)node.getProperty(Properties.NODE_TYPE))) {
            case LONG_EDGE: {
                LEdge edge = (LEdge)node.getProperty(Properties.ORIGIN);
                KVectorChain bendpoints = (KVectorChain)edge.getProperty(Properties.ORIGINAL_BENDPOINTS);
                if (bendpoints == null) {
                    bendpoints = new KVectorChain();
                } else if (((Boolean)edge.getProperty(Properties.REVERSED)).booleanValue()) {
                    bendpoints = KVectorChain.reverse((KVectorChain)bendpoints);
                }
                LPort source = (LPort)node.getProperty(Properties.LONG_EDGE_SOURCE);
                KVector sourcePoint = source.getAbsoluteAnchor();
                if (horizPos <= sourcePoint.x) {
                    return sourcePoint.y;
                }
                bendpoints.addFirst((Object)sourcePoint);
                LPort target = (LPort)node.getProperty(Properties.LONG_EDGE_TARGET);
                KVector targetPoint = target.getAbsoluteAnchor();
                if (targetPoint.x <= horizPos) {
                    return targetPoint.y;
                }
                bendpoints.addLast((Object)targetPoint);
                Iterator pointIter = bendpoints.iterator();
                KVector point1 = (KVector)pointIter.next();
                KVector point2 = (KVector)pointIter.next();
                while (point2.x < horizPos && pointIter.hasNext()) {
                    point1 = point2;
                    point2 = (KVector)pointIter.next();
                }
                return (point1.y + point2.y) / 2.0;
            }
            case NORTH_SOUTH_PORT: {
                LPort originPort = (LPort)node.getPorts().get(0).getProperty(Properties.ORIGIN);
                LNode originNode = originPort.getNode();
                switch (originPort.getSide()) {
                    case NORTH: {
                        return originNode.getPosition().y;
                    }
                    case SOUTH: {
                        return originNode.getPosition().y + originNode.getSize().y;
                    }
                }
            }
        }
        return node.getInteractiveReferencePoint((LGraph)graph).y;
    }
}

