/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.components.AbstractGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.ComponentGroupGraphPlacer;
import de.cau.cs.kieler.klay.layered.components.SimpleRowGraphPlacer;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsProcessor
extends AbstractAlgorithm {
    private AbstractGraphPlacer graphPlacer = null;

    public List<LGraph> split(LGraph graph) {
        ArrayList<LGraph> result;
        boolean compatiblePortConstraints;
        Boolean separateProperty = (Boolean)graph.getProperty(LayoutOptions.SEPARATE_CC);
        boolean separate = separateProperty == null || separateProperty != false;
        boolean extPorts = ((Set)graph.getProperty(Properties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS);
        PortConstraints extPortConstraints = (PortConstraints)graph.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        boolean bl = compatiblePortConstraints = extPortConstraints == PortConstraints.FREE || extPortConstraints == PortConstraints.FIXED_SIDE;
        if (separate && (compatiblePortConstraints || !extPorts)) {
            for (LNode node : graph.getLayerlessNodes()) {
                node.id = 0;
            }
            result = new LinkedList();
            for (LNode node : graph.getLayerlessNodes()) {
                Pair<List<LNode>, Set<PortSide>> componentData = this.dfs(node, null);
                if (componentData == null) continue;
                LGraph newGraph = new LGraph(graph);
                newGraph.copyProperties((IPropertyHolder)graph);
                newGraph.setProperty(Properties.EXT_PORT_CONNECTIONS, componentData.getSecond());
                newGraph.getInsets().copy(graph.getInsets());
                newGraph.getLayerlessNodes().addAll((Collection)componentData.getFirst());
                result.add(newGraph);
            }
            this.graphPlacer = extPorts ? new ComponentGroupGraphPlacer() : new SimpleRowGraphPlacer();
        } else {
            result = new ArrayList<LGraph>(1);
            result.add(graph);
            this.graphPlacer = new SimpleRowGraphPlacer();
        }
        return result;
    }

    private Pair<List<LNode>, Set<PortSide>> dfs(LNode node, Pair<List<LNode>, Set<PortSide>> data) {
        if (node.id == 0) {
            node.id = 1;
            Pair mutableData = data;
            if (mutableData == null) {
                LinkedList component = new LinkedList();
                EnumSet<PortSide> extPortSides = EnumSet.noneOf(PortSide.class);
                mutableData = new Pair(component, extPortSides);
            }
            ((List)mutableData.getFirst()).add(node);
            if (node.getProperty(Properties.NODE_TYPE) == NodeType.EXTERNAL_PORT) {
                ((Set)mutableData.getSecond()).add((PortSide)node.getProperty(Properties.EXT_PORT_SIDE));
            }
            for (LPort port1 : node.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    this.dfs(port2.getNode(), (Pair<List<LNode>, Set<PortSide>>)mutableData);
                }
            }
            return mutableData;
        }
        return null;
    }

    public LGraph pack(List<LGraph> components) {
        LGraph combinedGraph = this.graphPlacer.combine(components);
        return combinedGraph;
    }
}

