/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.model;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import de.cau.cs.kieler.klay.force.model.AbstractForceModel;
import de.cau.cs.kieler.klay.force.properties.Properties;

public class EadesModel
extends AbstractForceModel {
    private static final double ZERO_FACTOR = 100.0;
    private int maxIterations = (Integer)Properties.ITERATIONS.getDefault();
    private double springLength = ((Float)Properties.SPACING.getDefault()).floatValue();
    private double repulsionFactor = ((Float)Properties.REPULSION.getDefault()).floatValue();

    protected void initialize(FGraph graph) {
        super.initialize(graph);
        this.maxIterations = (Integer)graph.getProperty((IProperty)Properties.ITERATIONS);
        this.springLength = ((Float)graph.getProperty((IProperty)Properties.SPACING)).floatValue();
        this.repulsionFactor = ((Float)graph.getProperty((IProperty)Properties.REPULSION)).floatValue();
    }

    protected boolean moreIterations(int count) {
        return count < this.maxIterations;
    }

    protected KVector calcDisplacement(FParticle forcer, FParticle forcee) {
        EadesModel.avoidSamePosition(this.getRandom(), forcer, forcee);
        KVector displacement = forcee.getPosition().differenceCreate(forcer.getPosition());
        double length = displacement.getLength();
        double d = Math.max(0.0, length - forcer.getRadius() - forcee.getRadius());
        int connection = this.getGraph().getConnection(forcer, forcee);
        double force = connection > 0 ? -EadesModel.attractive(d, this.springLength) * (double)connection : EadesModel.repulsive(d, this.repulsionFactor) * (double)((Integer)forcer.getProperty((IProperty)Properties.PRIORITY)).intValue();
        displacement.scale(force / length);
        return displacement;
    }

    private static double repulsive(double d, double r) {
        if (d > 0.0) {
            return r / (d * d);
        }
        return r * 100.0;
    }

    public static double attractive(double d, double s) {
        if (d > 0.0) {
            return Math.log(d / s);
        }
        return -100.0;
    }
}

