/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.util;

import de.cau.cs.kieler.core.util.Maybe;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoredOperation {
    private IStatus lastStatus;

    protected abstract IStatus execute(IProgressMonitor var1);

    protected void preUIexec() {
    }

    protected void postUIexec() {
    }

    public final void runMonitored() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
            this.runMonitored(display, false);
        } else {
            this.runMonitored(display, true);
        }
    }

    public final void runUnmonitored() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
            this.runUnmonitored(display, false);
        } else {
            this.runUnmonitored(display, true);
        }
    }

    private void runUnmonitored(Display display, boolean isUiThread) {
        final Maybe status = new Maybe();
        if (isUiThread) {
            try {
                this.preUIexec();
                Thread thread = new Thread("Monitored Operation"){

                    public void run() {
                        status.set((Object)MonitoredOperation.this.execute(null));
                        if (!$assertionsDisabled && status.get() == null) {
                            throw new AssertionError();
                        }
                    }
                };
                thread.start();
                while (status.get() == null) {
                    boolean hasMoreToDispatch;
                    while ((hasMoreToDispatch = display.readAndDispatch()) && status.get() == null) {
                    }
                    if (status.get() != null) continue;
                    display.sleep();
                }
                if (((IStatus)status.get()).getSeverity() == 0) {
                    this.postUIexec();
                }
            }
            catch (Throwable throwable) {
                status.set((Object)new Status(4, "de.cau.cs.kieler.kiml.ui", "Error in monitored operation", throwable));
            }
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    try {
                        MonitoredOperation.this.preUIexec();
                    }
                    catch (Throwable throwable) {
                        status.set((Object)new Status(4, "de.cau.cs.kieler.kiml.ui", "Error in monitored operation", throwable));
                    }
                }
            });
            if (status.get() == null) {
                status.set((Object)this.execute(null));
                if (((IStatus)status.get()).getSeverity() == 0) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            try {
                                MonitoredOperation.this.postUIexec();
                            }
                            catch (Throwable throwable) {
                                status.set((Object)new Status(4, "de.cau.cs.kieler.kiml.ui", "Error in monitored operation", throwable));
                            }
                        }
                    });
                }
            }
        }
        this.handleStatus((Maybe<IStatus>)status);
    }

    private void runMonitored(final Display display, boolean isUiThread) {
        final Maybe monitor = new Maybe();
        final Maybe status = new Maybe();
        if (isUiThread) {
            Thread thread = new Thread("Monitored Operation"){

                public void run() {
                    MonitoredOperation.this.runOperation(display, (Maybe<IProgressMonitor>)monitor, (Maybe<IStatus>)status);
                }
            };
            thread.start();
            this.runUiHandler(display, (Maybe<IProgressMonitor>)monitor, (Maybe<IStatus>)status);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    MonitoredOperation.this.runUiHandler(display, (Maybe<IProgressMonitor>)monitor, (Maybe<IStatus>)status);
                }
            });
            this.runOperation(display, (Maybe<IProgressMonitor>)monitor, (Maybe<IStatus>)status);
        }
        this.handleStatus((Maybe<IStatus>)status);
    }

    private void handleStatus(Maybe<IStatus> status) {
        if (status.get() != null) {
            this.lastStatus = (IStatus)status.get();
            int handlingStyle = 0;
            switch (this.lastStatus.getSeverity()) {
                case 4: {
                    handlingStyle = 3;
                    break;
                }
                case 1: 
                case 2: {
                    handlingStyle = 1;
                }
            }
            StatusManager.getManager().handle(this.lastStatus, handlingStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOperation(Display display, Maybe<IProgressMonitor> monitor, Maybe<IStatus> status) {
        try {
            Maybe<IProgressMonitor> maybe = monitor;
            synchronized (maybe) {
                while (monitor.get() == null) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (status.get() == null) {
                status.set((Object)this.execute((IProgressMonitor)monitor.get()));
                assert (status.get() != null);
            }
        }
        catch (Throwable throwable) {
            Maybe<IStatus> maybe = status;
            synchronized (maybe) {
                if (status.get() == null) {
                    status.set((Object)Status.OK_STATUS);
                }
                display.wake();
                throw throwable;
            }
        }
        Maybe<IStatus> maybe = status;
        synchronized (maybe) {
            if (status.get() == null) {
                status.set((Object)Status.OK_STATUS);
            }
            display.wake();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUiHandler(final Display display, final Maybe<IProgressMonitor> monitor, final Maybe<IStatus> status) {
        try {
            this.preUIexec();
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){
                private static /* synthetic */ int[] $SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public void run(IProgressMonitor uiMonitor) {
                    monitorWrapper = new ProgressMonitorWrapper(display);
                    var3_3 = monitor;
                    synchronized (var3_3) {
                        monitor.set((Object)monitorWrapper);
                        monitor.notify();
                        // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (true) ** GOTO lbl47
                    }
                    do {
                        hasMoreToDispatch = false;
                        do {
                            hasMoreToDispatch = display.readAndDispatch();
                            ProgressMonitorWrapper.access$0(monitorWrapper, uiMonitor.isCanceled());
                        } while (hasMoreToDispatch && status.get() == null);
                        if (status.get() == null) {
                            display.sleep();
                        }
                        while (!ProgressMonitorWrapper.access$1(monitorWrapper).isEmpty() && status.get() == null) {
                            var5_6 = ProgressMonitorWrapper.access$1(monitorWrapper);
                            synchronized (var5_6) {
                                command = (ProgressMonitorWrapper.Command)ProgressMonitorWrapper.access$1(monitorWrapper).removeFirst();
                            }
                            switch (6.$SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType()[ProgressMonitorWrapper.Command.access$1(command).ordinal()]) {
                                case 1: {
                                    uiMonitor.beginTask(ProgressMonitorWrapper.Command.access$2(command), ProgressMonitorWrapper.Command.access$3(command));
                                    break;
                                }
                                case 2: {
                                    uiMonitor.setTaskName(ProgressMonitorWrapper.Command.access$2(command));
                                    break;
                                }
                                case 3: {
                                    uiMonitor.subTask(ProgressMonitorWrapper.Command.access$2(command));
                                    break;
                                }
                                case 4: {
                                    uiMonitor.worked(ProgressMonitorWrapper.Command.access$3(command));
                                    break;
                                }
                                case 5: {
                                    uiMonitor.internalWorked((double)ProgressMonitorWrapper.Command.access$3(command));
                                }
                                case 6: {
                                    uiMonitor.done();
                                    return;
                                }
                            }
                        }
lbl47:
                        // 2 sources

                    } while (status.get() == null);
                }

                static /* synthetic */ int[] $SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType() {
                    if ($SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType != null) {
                        return $SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType;
                    }
                    int[] nArray = new int[ProgressMonitorWrapper.CommandType.values().length];
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.BEGIN_TASK.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.DONE.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.INTERNAL_WORKED.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.SET_TASK_NAME.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.SUB_TASK.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[ProgressMonitorWrapper.CommandType.WORKED.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    $SWITCH_TABLE$de$cau$cs$kieler$kiml$ui$util$MonitoredOperation$ProgressMonitorWrapper$CommandType = nArray;
                    return nArray;
                }
            });
            while (status.get() == null) {
                boolean hasMoreToDispatch;
                while ((hasMoreToDispatch = display.readAndDispatch()) && status.get() == null) {
                }
                if (status.get() != null) continue;
                display.sleep();
            }
            if (((IStatus)status.get()).getSeverity() == 0) {
                this.postUIexec();
            }
        }
        catch (Throwable throwable) {
            Maybe<IProgressMonitor> maybe = monitor;
            synchronized (maybe) {
                if (monitor.get() == null) {
                    monitor.set((Object)new NullProgressMonitor());
                    monitor.notify();
                }
            }
            maybe = status;
            synchronized (maybe) {
                if (status.get() == null || ((IStatus)status.get()).getSeverity() == 0) {
                    status.set((Object)new Status(4, "de.cau.cs.kieler.kiml.ui", "Error in monitored operation", throwable));
                    this.handleStatus(status);
                }
            }
        }
    }

    public IStatus getStatus() {
        return this.lastStatus;
    }

    public static final void runInUI(Runnable runnable, boolean synch) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
            if (synch) {
                display.syncExec(runnable);
            } else {
                display.asyncExec(runnable);
            }
        } else {
            runnable.run();
        }
    }

    private static class ProgressMonitorWrapper
    implements IProgressMonitor {
        private LinkedList<Command> commands = new LinkedList();
        private boolean canceled = false;
        private Display display;

        public ProgressMonitorWrapper(Display thedisplay) {
            this.display = thedisplay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginTask(String name, int totalWork) {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.BEGIN_TASK, name, totalWork));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.DONE, null, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void internalWorked(double work) {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.INTERNAL_WORKED, null, (int)work));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTaskName(String name) {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.SET_TASK_NAME, name, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subTask(String name) {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.SUB_TASK, name, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void worked(int work) {
            LinkedList<Command> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new Command(CommandType.WORKED, null, work));
            }
            this.display.wake();
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.canceled = value;
        }

        static /* synthetic */ void access$0(ProgressMonitorWrapper progressMonitorWrapper, boolean bl) {
            progressMonitorWrapper.canceled = bl;
        }

        static /* synthetic */ LinkedList access$1(ProgressMonitorWrapper progressMonitorWrapper) {
            return progressMonitorWrapper.commands;
        }

        static final class Command {
            private CommandType type;
            private String name;
            private int work;

            private Command(CommandType thetype, String thename, int thework) {
                this.type = thetype;
                this.name = thename;
                this.work = thework;
            }

            static /* synthetic */ CommandType access$1(Command command) {
                return command.type;
            }

            static /* synthetic */ String access$2(Command command) {
                return command.name;
            }

            static /* synthetic */ int access$3(Command command) {
                return command.work;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum CommandType {
            BEGIN_TASK,
            SET_TASK_NAME,
            SUB_TASK,
            WORKED,
            INTERNAL_WORKED,
            DONE;

        }
    }
}

