/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortSideAnalysis
implements IAnalysis {
    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Port side analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int north = 0;
        int east = 0;
        int south = 0;
        int west = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            Direction direction = Direction.UNDEFINED;
            if (node.getParent() != null) {
                direction = (Direction)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.DIRECTION);
            }
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)portLayout.getProperty(LayoutOptions.PORT_SIDE);
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide((KPort)port, (Direction)direction);
                }
                switch (portSide) {
                    case NORTH: {
                        ++north;
                        break;
                    }
                    case EAST: {
                        ++east;
                        break;
                    }
                    case SOUTH: {
                        ++south;
                        break;
                    }
                    case WEST: {
                        ++west;
                    }
                }
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        progressMonitor.done();
        return new Object[]{north, east, south, west};
    }
}

