/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedComponentsAnalysis
implements IAnalysis {
    private Map<KNode, Boolean> visitedMap = new HashMap<KNode, Boolean>();

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Connected Components Analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int count = this.countComponents(parentNode, hierarchy);
        this.visitedMap.clear();
        progressMonitor.done();
        return count;
    }

    private int countComponents(KNode parent, boolean hierarchy) {
        int count = 0;
        for (KNode child : parent.getChildren()) {
            count += this.dfs(child);
            if (!hierarchy) continue;
            count += this.countComponents(child, true);
        }
        return count;
    }

    private int dfs(KNode node) {
        Boolean visited = this.visitedMap.get(node);
        if (visited == null) {
            this.visitedMap.put(node, true);
            for (KEdge edge : node.getOutgoingEdges()) {
                KNode target = edge.getTarget();
                if (node.getParent() != target.getParent()) continue;
                this.dfs(target);
            }
            for (KEdge edge : node.getIncomingEdges()) {
                KNode source = edge.getSource();
                if (node.getParent() != source.getParent()) continue;
                this.dfs(source);
            }
            return 1;
        }
        return 0;
    }
}

