/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphPackage;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataPackage;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.formats.AbstractEmfHandler;
import de.cau.cs.kieler.kiml.service.formats.IGraphTransformer;
import de.cau.cs.kieler.kiml.service.formats.TransformationData;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGraphHandler
extends AbstractEmfHandler<KNode> {
    public static final String FORMAT = "de.cau.cs.kieler.kgraph";
    private static final IGraphTransformer<KNode, KNode> TRANSFORMER = new IGraphTransformer<KNode, KNode>(){

        @Override
        public void transform(TransformationData<KNode, KNode> data) {
            KNode graph = data.getSourceGraph();
            KGraphHandler.validate(graph);
            data.getTargetGraphs().add(graph);
        }

        @Override
        public void transferLayout(TransformationData<KNode, KNode> data) {
        }
    };

    @Override
    public String serialize(KNode graph) {
        KimlUtil.persistDataElements((KNode)graph);
        return super.serialize(graph);
    }

    @Override
    public void deserialize(String serializedGraph, TransformationData<KNode, KNode> transData) {
        super.deserialize(serializedGraph, transData);
        if (transData.getSourceGraph() != null) {
            KimlUtil.loadDataElements((KNode)transData.getSourceGraph());
        }
    }

    @Override
    protected ResourceSet createResourceSet() {
        EPackage.Registry registry;
        Map extensionMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!extensionMap.containsKey("kgraph")) {
            extensionMap.put("kgraph", new XMIResourceFactoryImpl());
        }
        if (!(registry = EPackage.Registry.INSTANCE).containsKey((Object)"http://kieler.cs.cau.de/KGraph")) {
            registry.put((Object)"http://kieler.cs.cau.de/KGraph", (Object)KGraphPackage.eINSTANCE);
        }
        if (!registry.containsKey((Object)"http://kieler.cs.cau.de/KLayoutData")) {
            registry.put((Object)"http://kieler.cs.cau.de/KLayoutData", (Object)KLayoutDataPackage.eINSTANCE);
        }
        return new ResourceSetImpl();
    }

    @Override
    public IGraphTransformer<KNode, KNode> getImporter() {
        return TRANSFORMER;
    }

    @Override
    public IGraphTransformer<KNode, KNode> getExporter() {
        return TRANSFORMER;
    }

    private static void validate(KNode graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph instance is null");
        }
        KLayoutDataFactory layoutFactory = KLayoutDataFactory.eINSTANCE;
        TreeIterator contentIter = graph.eAllContents();
        while (contentIter.hasNext()) {
            KEdge edge;
            KEdgeLayout eLayout;
            KShapeLayout sLayout;
            EObject element = (EObject)contentIter.next();
            if (element instanceof KNode) {
                KNode node = (KNode)element;
                sLayout = (KShapeLayout)node.getData(KShapeLayout.class);
                if (sLayout == null) {
                    sLayout = layoutFactory.createKShapeLayout();
                    node.getData().add((Object)sLayout);
                }
                if (sLayout.getInsets() != null) continue;
                sLayout.setInsets(layoutFactory.createKInsets());
                continue;
            }
            if (element instanceof KPort) {
                KPort port = (KPort)element;
                sLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                if (sLayout != null) continue;
                port.getData().add((Object)layoutFactory.createKShapeLayout());
                continue;
            }
            if (element instanceof KLabel) {
                KLabel label = (KLabel)element;
                sLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (sLayout == null) {
                    label.getData().add((Object)layoutFactory.createKShapeLayout());
                }
                if (label.getText() != null) continue;
                label.setText("");
                continue;
            }
            if (!(element instanceof KEdge) || (eLayout = (KEdgeLayout)(edge = (KEdge)element).getData(KEdgeLayout.class)) != null) continue;
            eLayout = layoutFactory.createKEdgeLayout();
            eLayout.setSourcePoint(layoutFactory.createKPoint());
            eLayout.setTargetPoint(layoutFactory.createKPoint());
            edge.getData().add((Object)eLayout);
        }
    }
}

