/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphviz.dot.transform;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.Attribute;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.AttributeStatement;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.AttributeType;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.DotFactory;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.EdgeStatement;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.EdgeTarget;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.Graph;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.GraphType;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.GraphvizModel;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.Node;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.NodeStatement;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.Statement;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.Subgraph;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.Attributes;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.Command;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.NeatoModel;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.OverlapMode;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.service.formats.IGraphTransformer;
import de.cau.cs.kieler.kiml.service.formats.TransformationData;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotExporter
implements IGraphTransformer<KNode, GraphvizModel> {
    public static final float DEF_SPACING_SMALL = 20.0f;
    public static final float DEF_SPACING_LARGE = 40.0f;
    public static final float DEF_SPACING_XLARGE = 60.0f;
    public static final float DPI = 72.0f;
    public static final IProperty<Command> COMMAND = new Property("dotExporter.command", (Object)Command.DOT);
    public static final IProperty<Boolean> USE_EDGE_IDS = new Property("dotExporter.useEdgeIds", (Object)false);
    public static final IProperty<Boolean> FULL_EXPORT = new Property("dotExporter.fullExport", (Object)true);
    private static final double FONT_SIZE_MULT = 1.4;
    private static final String ATTRIBUTE_DELIM = "\", \t\n\r";
    private static final IProperty<BiMap<String, KGraphElement>> GRAPH_ELEMS = new Property("dotExporter.graphElemMap");
    private static final IProperty<Boolean> USE_SPLINES = new Property("dotExporter.useSplines", (Object)false);
    private static final IProperty<Integer> NEXT_NODE_ID = new Property("dotExporter.nextNodeId", (Object)1);
    private static final IProperty<Integer> NEXT_EDGE_ID = new Property("dotExporter.nextEdgeId", (Object)1);
    private static final IProperty<String> CLUSTER_DUMMY = new Property("dotExporter.clusterDummy");
    private static final float NSLIMIT_BASE = 100.0f;
    private static final char MIN_OUT_CHAR = ' ';
    private static final char MAX_OUT_CHAR = '~';

    public void transform(TransformationData<KNode, GraphvizModel> transData) {
        transData.setProperty(GRAPH_ELEMS, (Object)HashBiMap.create());
        KNode kgraph = (KNode)transData.getSourceGraph();
        GraphvizModel graphvizModel = DotFactory.eINSTANCE.createGraphvizModel();
        Graph graph = DotFactory.eINSTANCE.createGraph();
        graph.setType(GraphType.DIGRAPH);
        graphvizModel.getGraphs().add((Object)graph);
        Command command = (Command)((Object)transData.getProperty(COMMAND));
        boolean layoutHierarchy = (Boolean)transData.getProperty(FULL_EXPORT) != false || (Boolean)((KShapeLayout)kgraph.getData(KShapeLayout.class)).getProperty(LayoutOptions.LAYOUT_HIERARCHY) != false && (command == Command.DOT || command == Command.FDP);
        this.transformNodes(kgraph, (List<Statement>)graph.getStatements(), layoutHierarchy, new KVector(), transData);
        this.transformEdges(kgraph, (List<Statement>)graph.getStatements(), layoutHierarchy, transData);
        transData.getTargetGraphs().add(graphvizModel);
    }

    public void transferLayout(TransformationData<KNode, GraphvizModel> transData) {
        float borderSpacing = ((Float)((KShapeLayout)((KNode)transData.getSourceGraph()).getData(KShapeLayout.class)).getProperty(LayoutOptions.BORDER_SPACING)).floatValue();
        if (borderSpacing < 0.0f) {
            borderSpacing = 10.0f;
        }
        Graph graph = (Graph)((GraphvizModel)transData.getTargetGraphs().get(0)).getGraphs().get(0);
        KVector baseOffset = new KVector();
        this.applyLayout((KNode)transData.getSourceGraph(), (List<Statement>)graph.getStatements(), baseOffset, borderSpacing, transData);
        LinkedList<Statement> statements = new LinkedList<Statement>((Collection<Statement>)graph.getStatements());
        KVector edgeOffset = baseOffset.translate((double)borderSpacing, (double)borderSpacing);
        while (!statements.isEmpty()) {
            Statement statement = statements.removeFirst();
            if (statement instanceof EdgeStatement) {
                this.applyEdgeLayout((EdgeStatement)statement, edgeOffset, borderSpacing, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            statements.addAll((Collection<Statement>)((Subgraph)statement).getStatements());
        }
    }

    private void transformNodes(KNode parent, List<Statement> statements, boolean hierarchy, KVector offset, TransformationData<KNode, GraphvizModel> transData) {
        boolean fullExport = (Boolean)transData.getProperty(FULL_EXPORT);
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        boolean interactive = (Boolean)parentLayout.getProperty(LayoutOptions.INTERACTIVE);
        if (!fullExport) {
            this.setGraphAttributes(statements, (KGraphData)parentLayout, transData);
        }
        for (KNode childNode : parent.getChildren()) {
            String nodeID;
            KShapeLayout nodeLayout = (KShapeLayout)childNode.getData(KShapeLayout.class);
            NodeStatement nodeStatement = DotFactory.eINSTANCE.createNodeStatement();
            EList<Attribute> attributes = nodeStatement.getAttributes();
            if (hierarchy && !childNode.getChildren().isEmpty()) {
                String clusterNodeID = this.getNodeID(childNode, NodeType.CLUSTER, transData);
                Subgraph subgraph = DotFactory.eINSTANCE.createSubgraph();
                subgraph.setName(clusterNodeID);
                statements.add(subgraph);
                double subgraphx = nodeLayout.getXpos() + nodeLayout.getInsets().getLeft();
                double subgraphy = nodeLayout.getYpos() + nodeLayout.getInsets().getTop();
                this.transformNodes(childNode, (List<Statement>)subgraph.getStatements(), true, new KVector(offset).translate(subgraphx, subgraphy), transData);
                nodeID = this.getNodeID(childNode, NodeType.DUMMY, transData);
                attributes.add(DotExporter.createAttribute("style", "invis"));
                attributes.add(DotExporter.createAttribute("width", 0));
                attributes.add(DotExporter.createAttribute("height", 0));
                subgraph.getStatements().add((Object)nodeStatement);
            } else {
                nodeID = this.getNodeID(childNode, NodeType.NODE, transData);
                KimlUtil.resizeNode((KNode)childNode);
                if (nodeLayout.getWidth() > 0.0f) {
                    attributes.add(DotExporter.createAttribute("width", nodeLayout.getWidth() / 72.0f));
                }
                if (nodeLayout.getHeight() > 0.0f) {
                    attributes.add(DotExporter.createAttribute("height", nodeLayout.getHeight() / 72.0f));
                }
                if (!childNode.getLabels().isEmpty() && ((KLabel)childNode.getLabels().get(0)).getText().length() > 0 && fullExport) {
                    attributes.add(DotExporter.createAttribute("label", DotExporter.createString(((KLabel)childNode.getLabels().get(0)).getText())));
                }
                if ((interactive || fullExport && !((Boolean)nodeLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) && (nodeLayout.getXpos() != 0.0f || nodeLayout.getYpos() != 0.0f)) {
                    double xpos = (double)(nodeLayout.getXpos() + nodeLayout.getWidth() / 2.0f) + offset.x;
                    double ypos = (double)(nodeLayout.getYpos() + nodeLayout.getHeight() / 2.0f) + offset.y;
                    String posString = "\"" + Double.toString(xpos) + "," + Double.toString(ypos) + "\"";
                    attributes.add(DotExporter.createAttribute("pos", posString));
                }
                statements.add(nodeStatement);
            }
            Node node = DotFactory.eINSTANCE.createNode();
            node.setName(nodeID);
            nodeStatement.setNode(node);
        }
    }

    private void transformEdges(KNode parent, List<Statement> statements, boolean hierarchy, TransformationData<KNode, GraphvizModel> transData) {
        boolean fullExport = (Boolean)transData.getProperty(FULL_EXPORT);
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        Direction layoutDirection = (Direction)parentLayout.getProperty(LayoutOptions.DIRECTION);
        boolean vertical = layoutDirection == Direction.DOWN || layoutDirection == Direction.UP;
        LinkedList nodes = new LinkedList(parent.getChildren());
        BiMap nodeIds = ((BiMap)transData.getProperty(GRAPH_ELEMS)).inverse();
        while (!nodes.isEmpty()) {
            KNode source = (KNode)nodes.removeFirst();
            for (KEdge edge : source.getOutgoingEdges()) {
                KNode target = edge.getTarget();
                if (source.getParent() != target.getParent() && (!hierarchy || !this.isInsideGraph(target, (KNode)transData.getSourceGraph()))) continue;
                EdgeStatement edgeStatement = DotFactory.eINSTANCE.createEdgeStatement();
                EList<Attribute> attributes = edgeStatement.getAttributes();
                Node sourceNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !source.getChildren().isEmpty()) {
                    sourceNode.setName((String)((KShapeLayout)source.getData(KShapeLayout.class)).getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("ltail", (String)nodeIds.get((Object)source)));
                } else {
                    sourceNode.setName((String)nodeIds.get((Object)source));
                }
                edgeStatement.setSourceNode(sourceNode);
                EdgeTarget edgeTarget = DotFactory.eINSTANCE.createEdgeTarget();
                Node targetNode = DotFactory.eINSTANCE.createNode();
                if (hierarchy && !target.getChildren().isEmpty()) {
                    targetNode.setName((String)((KShapeLayout)target.getData(KShapeLayout.class)).getProperty(CLUSTER_DUMMY));
                    attributes.add(DotExporter.createAttribute("lhead", (String)nodeIds.get((Object)target)));
                } else {
                    targetNode.setName((String)nodeIds.get((Object)target));
                }
                edgeTarget.setTargetnode(targetNode);
                edgeStatement.getEdgeTargets().add((Object)edgeTarget);
                DotExporter.setEdgeLabels(edge, attributes, vertical);
                if (((Boolean)transData.getProperty(USE_EDGE_IDS)).booleanValue()) {
                    String edgeID = this.getEdgeID(edge, transData);
                    attributes.add(DotExporter.createAttribute("comment", "\"" + edgeID + "\""));
                }
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                KPoint targetPoint = edgeLayout.getTargetPoint();
                if (fullExport && !((Boolean)edgeLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue() && (edgeLayout.getBendPoints().size() > 0 || sourcePoint.getX() != 0.0f || sourcePoint.getY() != 0.0f || targetPoint.getX() != 0.0f || targetPoint.getY() != 0.0f)) {
                    KNode referenceNode = source;
                    if (!KimlUtil.isDescendant((KNode)target, (KNode)source)) {
                        referenceNode = source.getParent();
                    }
                    StringBuilder pos = new StringBuilder();
                    Iterator pointIter = edgeLayout.createVectorChain().iterator();
                    while (pointIter.hasNext()) {
                        KVector point = (KVector)pointIter.next();
                        KimlUtil.toAbsolute((KVector)point, (KNode)referenceNode);
                        pos.append(point.x);
                        pos.append(",");
                        pos.append(point.y);
                        if (!pointIter.hasNext()) continue;
                        pos.append(" ");
                    }
                    attributes.add(DotExporter.createAttribute("pos", "\"" + pos + "\""));
                }
                statements.add(edgeStatement);
            }
            if (!hierarchy) continue;
            nodes.addAll(source.getChildren());
        }
    }

    private boolean isInsideGraph(KNode node, KNode root) {
        KNode n = node;
        do {
            if (n != root) continue;
            return true;
        } while ((n = n.getParent()) != null);
        return false;
    }

    private void setGraphAttributes(List<Statement> statements, KGraphData parentLayout, TransformationData<KNode, GraphvizModel> transData) {
        String splineMode;
        int maxiter;
        Command command = (Command)((Object)transData.getProperty(COMMAND));
        AttributeStatement graphAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        graphAttrStatement.setType(AttributeType.GRAPH);
        EList<Attribute> graphAttrs = graphAttrStatement.getAttributes();
        statements.add(graphAttrStatement);
        AttributeStatement nodeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        nodeAttrStatement.setType(AttributeType.NODE);
        EList<Attribute> nodeAttrs = nodeAttrStatement.getAttributes();
        statements.add(nodeAttrStatement);
        nodeAttrs.add(DotExporter.createAttribute("shape", "box"));
        nodeAttrs.add(DotExporter.createAttribute("fixedsize", "true"));
        AttributeStatement edgeAttrStatement = DotFactory.eINSTANCE.createAttributeStatement();
        edgeAttrStatement.setType(AttributeType.EDGE);
        EList<Attribute> edgeAttrs = edgeAttrStatement.getAttributes();
        statements.add(edgeAttrStatement);
        edgeAttrs.add(DotExporter.createAttribute("dir", "none"));
        float minSpacing = ((Float)parentLayout.getProperty(LayoutOptions.SPACING)).floatValue();
        if (minSpacing < 0.0f) {
            switch (command) {
                case NEATO: 
                case FDP: 
                case CIRCO: {
                    minSpacing = 40.0f;
                    break;
                }
                case TWOPI: {
                    minSpacing = 60.0f;
                    break;
                }
                default: {
                    minSpacing = 20.0f;
                }
            }
        }
        switch (command) {
            case DOT: {
                graphAttrs.add(DotExporter.createAttribute("nodesep", minSpacing / 72.0f));
                float rankSepFactor = ((Float)parentLayout.getProperty(Attributes.RANK_SEP_PROP)).floatValue();
                graphAttrs.add(DotExporter.createAttribute("ranksep", rankSepFactor * minSpacing / 72.0f));
                switch ((Direction)parentLayout.getProperty(LayoutOptions.DIRECTION)) {
                    case UP: {
                        graphAttrs.add(DotExporter.createAttribute("rankdir", "BT"));
                        break;
                    }
                    case LEFT: {
                        graphAttrs.add(DotExporter.createAttribute("rankdir", "RL"));
                        break;
                    }
                    case RIGHT: {
                        graphAttrs.add(DotExporter.createAttribute("rankdir", "LR"));
                        break;
                    }
                    default: {
                        graphAttrs.add(DotExporter.createAttribute("rankdir", "TB"));
                    }
                }
                float iterationsLimit = ((Float)parentLayout.getProperty(Attributes.ITER_LIMIT_PROP)).floatValue();
                if (iterationsLimit > 0.0f) {
                    graphAttrs.add(DotExporter.createAttribute("mclimit", iterationsLimit));
                    if (iterationsLimit < 1.0f) {
                        float simplexLimit = iterationsLimit * 100.0f;
                        graphAttrs.add(DotExporter.createAttribute("nslimit", simplexLimit));
                    }
                }
                if (!((Boolean)parentLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY)).booleanValue()) break;
                graphAttrs.add(DotExporter.createAttribute("compound", "true"));
                break;
            }
            case TWOPI: {
                graphAttrs.add(DotExporter.createAttribute("ranksep", minSpacing / 72.0f));
                break;
            }
            case CIRCO: {
                graphAttrs.add(DotExporter.createAttribute("mindist", minSpacing / 72.0f));
                break;
            }
            case NEATO: {
                NeatoModel model;
                edgeAttrs.add(DotExporter.createAttribute("len", minSpacing / 72.0f));
                Integer seed = (Integer)parentLayout.getProperty(LayoutOptions.RANDOM_SEED);
                if (seed == null) {
                    seed = 1;
                } else if (seed == 0) {
                    seed = -1;
                } else if (seed < 0) {
                    seed = -seed.intValue();
                }
                graphAttrs.add(DotExporter.createAttribute("start", "random" + seed));
                float epsilon = ((Float)parentLayout.getProperty(Attributes.EPSILON_PROP)).floatValue();
                if (epsilon > 0.0f) {
                    graphAttrs.add(DotExporter.createAttribute("epsilon", epsilon));
                }
                if ((model = (NeatoModel)((Object)parentLayout.getProperty(Attributes.NEATO_MODEL_PROP))) == NeatoModel.SHORTPATH) break;
                graphAttrs.add(DotExporter.createAttribute("model", model.literal()));
                break;
            }
            case FDP: {
                graphAttrs.add(DotExporter.createAttribute("K", minSpacing / 72.0f));
            }
        }
        if ((command == Command.NEATO || command == Command.FDP) && (maxiter = ((Integer)parentLayout.getProperty(Attributes.MAXITER_PROP)).intValue()) > 0) {
            graphAttrs.add(DotExporter.createAttribute("maxiter", maxiter));
        }
        if (command != Command.DOT) {
            OverlapMode mode = (OverlapMode)((Object)parentLayout.getProperty(Attributes.OVERLAP_PROP));
            if (mode != OverlapMode.NONE) {
                graphAttrs.add(DotExporter.createAttribute("overlap", mode.literal()));
                graphAttrs.add(DotExporter.createAttribute("sep", "+" + (int)(minSpacing / 2.0f)));
            }
            Boolean pack = (Boolean)parentLayout.getProperty(LayoutOptions.SEPARATE_CC);
            if (command == Command.TWOPI || pack != null && pack.booleanValue()) {
                graphAttrs.add(DotExporter.createAttribute("pack", (int)minSpacing));
            }
        }
        EdgeRouting edgeRouting = (EdgeRouting)parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        switch (edgeRouting) {
            case POLYLINE: {
                splineMode = "polyline";
                break;
            }
            case ORTHOGONAL: {
                splineMode = "ortho";
                break;
            }
            default: {
                splineMode = "spline";
                transData.setProperty(USE_SPLINES, (Object)true);
            }
        }
        graphAttrs.add(DotExporter.createAttribute("splines", splineMode));
        if (((Boolean)parentLayout.getProperty(Attributes.CONCENTRATE_PROP)).booleanValue()) {
            graphAttrs.add(DotExporter.createAttribute("concentrate", "true"));
        }
    }

    public static Attribute createAttribute(String name, String value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue(value);
        return attribute;
    }

    public static Attribute createAttribute(String name, int value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    public static Attribute createAttribute(String name, float value) {
        Attribute attribute = DotFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        attribute.setValue("\"" + value + "\"");
        return attribute;
    }

    private static void setEdgeLabels(KEdge kedge, List<Attribute> attributes, boolean isVertical) {
        if (kedge.getLabels().isEmpty()) {
            return;
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        StringBuilder midLabel = new StringBuilder();
        StringBuilder headLabel = new StringBuilder();
        StringBuilder tailLabel = new StringBuilder();
        String fontName = null;
        int fontSize = 0;
        boolean isCenterFontName = false;
        boolean isCenterFontSize = false;
        for (KLabel label : kedge.getLabels()) {
            StringBuilder buffer = midLabel;
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            EdgeLabelPlacement placement = (EdgeLabelPlacement)labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT);
            boolean takeFontName = false;
            boolean takeFontSize = false;
            switch (placement) {
                case CENTER: {
                    takeFontName = fontName == null || !isCenterFontName;
                    isCenterFontName = true;
                    takeFontSize = fontSize <= 0 || !isCenterFontSize;
                    isCenterFontSize = true;
                    break;
                }
                case HEAD: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = headLabel;
                    break;
                }
                case TAIL: {
                    takeFontName = fontName == null;
                    takeFontSize = fontSize <= 0;
                    buffer = tailLabel;
                }
            }
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(label.getText());
            if (takeFontName) {
                fontName = (String)labelLayout.getProperty(LayoutOptions.FONT_NAME);
            }
            if (!takeFontSize || (fontSize = ((Integer)labelLayout.getProperty(LayoutOptions.FONT_SIZE)).intValue()) <= 0) continue;
            fontSize = (int)((double)fontSize * 1.4);
        }
        if (midLabel.length() > 0) {
            float labelSpacing = ((Float)edgeLayout.getProperty(LayoutOptions.LABEL_SPACING)).floatValue();
            int charsToAdd = (labelSpacing < 1.0f ? 0 : (int)labelSpacing) - 1;
            int i = 0;
            while (i < charsToAdd) {
                midLabel.append(isVertical ? "O" : "\nO");
                ++i;
            }
            attributes.add(DotExporter.createAttribute("label", DotExporter.createString(midLabel.toString())));
        }
        if (headLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("headlabel", DotExporter.createString(headLabel.toString())));
        }
        if (tailLabel.length() > 0) {
            attributes.add(DotExporter.createAttribute("taillabel", DotExporter.createString(tailLabel.toString())));
        }
        if (fontName != null && fontName.length() > 0) {
            attributes.add(DotExporter.createAttribute("fontname", "\"" + fontName + "\""));
        }
        if (fontSize > 0) {
            attributes.add(DotExporter.createAttribute("fontsize", fontSize));
        }
        if (headLabel.length() > 0 || tailLabel.length() > 0) {
            float distance = ((Float)edgeLayout.getProperty(Attributes.LABEL_DISTANCE_PROP)).floatValue();
            if (distance >= 0.0f) {
                attributes.add(DotExporter.createAttribute("labeldistance", distance));
            }
            float angle = ((Float)edgeLayout.getProperty(Attributes.LABEL_ANGLE_PROP)).floatValue();
            attributes.add(DotExporter.createAttribute("labelangle", angle));
        }
    }

    private static String createString(String label) {
        StringBuilder escapeBuffer = new StringBuilder(label.length() + 2);
        escapeBuffer.append("\"");
        int i = 0;
        while (i < label.length()) {
            char c = label.charAt(i);
            if (c == '\"' || c == '\\' || c > '~') {
                escapeBuffer.append('_');
            } else if (c == '\n') {
                escapeBuffer.append("\\n");
            } else if (c >= ' ') {
                escapeBuffer.append(c);
            }
            ++i;
        }
        escapeBuffer.append('\"');
        return escapeBuffer.toString();
    }

    private String getNodeID(KNode node, NodeType type, TransformationData<KNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_NODE_ID);
        transData.setProperty(NEXT_NODE_ID, (Object)(id + 1));
        String idstring = null;
        switch (type) {
            case NODE: {
                idstring = "node" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case CLUSTER: {
                idstring = "cluster" + id;
                ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)node);
                break;
            }
            case DUMMY: {
                idstring = "dummy" + id;
                ((KShapeLayout)node.getData(KShapeLayout.class)).setProperty(CLUSTER_DUMMY, (Object)idstring);
            }
        }
        return idstring;
    }

    private String getEdgeID(KEdge edge, TransformationData<KNode, GraphvizModel> transData) {
        int id = (Integer)transData.getProperty(NEXT_EDGE_ID);
        transData.setProperty(NEXT_EDGE_ID, (Object)(id + 1));
        String idstring = "edge" + id;
        ((BiMap)transData.getProperty(GRAPH_ELEMS)).put((Object)idstring, (Object)edge);
        return idstring;
    }

    private void applyLayout(KNode parentNode, List<Statement> statements, KVector baseOffset, float borderSpacing, TransformationData<KNode, GraphvizModel> transData) {
        float spacing = borderSpacing;
        KVector nodeOffset = new KVector();
        block3: for (Statement statement : statements) {
            AttributeStatement attributeStatement;
            if (!(statement instanceof AttributeStatement) || (attributeStatement = (AttributeStatement)statement).getType() != AttributeType.GRAPH) continue;
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!attribute.getName().equals("bb")) continue;
                try {
                    StringTokenizer tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    double leftx = Double.parseDouble(tokenizer.nextToken());
                    double bottomy = Double.parseDouble(tokenizer.nextToken());
                    double rightx = Double.parseDouble(tokenizer.nextToken());
                    double topy = Double.parseDouble(tokenizer.nextToken());
                    KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
                    KInsets insets = parentLayout.getInsets();
                    float width = (float)(rightx - leftx) + insets.getLeft() + insets.getRight();
                    float height = (float)(bottomy - topy) + insets.getTop() + insets.getBottom();
                    if (parentNode == transData.getSourceGraph()) {
                        width += 2.0f * spacing;
                        height += 2.0f * spacing;
                        baseOffset.translate(-leftx, -topy);
                    } else {
                        parentLayout.setXpos((float)(baseOffset.x + leftx - (double)insets.getLeft() + (double)spacing));
                        parentLayout.setYpos((float)(baseOffset.y + topy - (double)insets.getTop() + (double)spacing));
                        spacing = 0.0f;
                        nodeOffset.x = -(baseOffset.x + leftx);
                        nodeOffset.y = -(baseOffset.y + topy);
                    }
                    KimlUtil.resizeNode((KNode)parentNode, (float)width, (float)height, (boolean)false);
                    parentLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, (Object)SizeConstraint.FIXED);
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        for (Statement statement : statements) {
            if (statement instanceof NodeStatement) {
                this.applyNodeLayout((NodeStatement)statement, nodeOffset, spacing, transData);
                continue;
            }
            if (!(statement instanceof Subgraph)) continue;
            Subgraph subgraph = (Subgraph)statement;
            KNode knode = (KNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)subgraph.getName());
            this.applyLayout(knode, (List<Statement>)subgraph.getStatements(), baseOffset, spacing, transData);
            KShapeLayout subGraphLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
            subGraphLayout.setXpos(subGraphLayout.getXpos() + (float)nodeOffset.x);
            subGraphLayout.setYpos(subGraphLayout.getYpos() + (float)nodeOffset.y);
        }
    }

    private void applyNodeLayout(NodeStatement nodeStatement, KVector offset, float spacing, TransformationData<KNode, GraphvizModel> transData) {
        KNode knode = (KNode)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)nodeStatement.getNode().getName());
        if (knode == null) {
            return;
        }
        KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
        float xpos = 0.0f;
        float ypos = 0.0f;
        float width = 0.0f;
        float height = 0.0f;
        for (Attribute attribute : nodeStatement.getAttributes()) {
            try {
                StringTokenizer tokenizer;
                if (attribute.getName().equals("pos")) {
                    KVector pos = new KVector();
                    pos.parse(attribute.getValue());
                    xpos = (float)(pos.x + offset.x + (double)spacing);
                    ypos = (float)(pos.y + offset.y + (double)spacing);
                    continue;
                }
                if (attribute.getName().equals("width")) {
                    tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                    width = Float.parseFloat(tokenizer.nextToken()) * 72.0f;
                    continue;
                }
                if (!attribute.getName().equals("height")) continue;
                tokenizer = new StringTokenizer(attribute.getValue(), ATTRIBUTE_DELIM);
                height = Float.parseFloat(tokenizer.nextToken()) * 72.0f;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nodeLayout.setXpos(xpos - width / 2.0f);
        nodeLayout.setYpos(ypos - height / 2.0f);
    }

    private void applyEdgeLayout(EdgeStatement edgeStatement, KVector edgeOffset, float spacing, TransformationData<KNode, GraphvizModel> transData) {
        String labelPos;
        Map<String, String> attributeMap = DotExporter.createAttributeMap(edgeStatement.getAttributes());
        KEdge kedge = (KEdge)((BiMap)transData.getProperty(GRAPH_ELEMS)).get((Object)attributeMap.get("comment"));
        if (kedge == null) {
            return;
        }
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        EList edgePoints = edgeLayout.getBendPoints();
        edgePoints.clear();
        String posString = attributeMap.get("pos");
        if (posString == null) {
            posString = "";
        }
        KNode referenceNode = kedge.getSource();
        if (!KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)referenceNode)) {
            referenceNode = referenceNode.getParent();
        }
        KVector reference = new KVector();
        while (referenceNode != null && referenceNode != transData.getSourceGraph()) {
            KShapeLayout nodeLayout = (KShapeLayout)referenceNode.getData(KShapeLayout.class);
            reference.x += (double)(nodeLayout.getXpos() + nodeLayout.getInsets().getLeft());
            reference.y += (double)(nodeLayout.getYpos() + nodeLayout.getInsets().getTop());
            referenceNode = referenceNode.getParent();
        }
        KVector offset = edgeOffset.differenceCreate(reference);
        LinkedList<KVectorChain> splines = new LinkedList<KVectorChain>();
        Pair<KVector, KVector> endpoints = DotExporter.parseSplinePoints(posString, splines, offset);
        KVector sourcePoint = (KVector)endpoints.getFirst();
        KVector targetPoint = (KVector)endpoints.getSecond();
        if (!splines.isEmpty()) {
            KShapeLayout targetLayout;
            KShapeLayout sourceLayout;
            KLayoutDataFactory layoutDataFactory = KLayoutDataFactory.eINSTANCE;
            if (sourcePoint == null) {
                List list = (List)splines.get(0);
                if (!list.isEmpty()) {
                    sourcePoint = (KVector)list.remove(0);
                } else {
                    sourceLayout = (KShapeLayout)kedge.getSource().getData(KShapeLayout.class);
                    sourcePoint = new KVector();
                    sourcePoint.x = sourceLayout.getXpos() + sourceLayout.getWidth() / 2.0f;
                    sourcePoint.y = sourceLayout.getYpos() + sourceLayout.getHeight() / 2.0f;
                }
            }
            if (targetPoint == null) {
                List list = (List)splines.get(splines.size() - 1);
                if (!list.isEmpty()) {
                    targetPoint = (KVector)list.remove(list.size() - 1);
                } else {
                    targetLayout = (KShapeLayout)kedge.getTarget().getData(KShapeLayout.class);
                    targetPoint = new KVector();
                    targetPoint.x = targetLayout.getXpos() + targetLayout.getWidth() / 2.0f;
                    targetPoint.y = targetLayout.getYpos() + targetLayout.getHeight() / 2.0f;
                }
            }
            for (KVectorChain kVectorChain : splines) {
                for (KVector point : kVectorChain) {
                    KPoint controlPoint = layoutDataFactory.createKPoint();
                    controlPoint.applyVector(point);
                    edgePoints.add(controlPoint);
                }
            }
            edgeLayout.getSourcePoint().applyVector(sourcePoint);
            edgeLayout.getTargetPoint().applyVector(targetPoint);
            if (kedge.getSourcePort() != null || kedge.getTargetPort() != null) {
                referenceNode = kedge.getSource();
                if (!KimlUtil.isDescendant((KNode)kedge.getTarget(), (KNode)referenceNode)) {
                    referenceNode = referenceNode.getParent();
                }
                if (kedge.getSourcePort() != null) {
                    KimlUtil.toAbsolute((KVector)sourcePoint, (KNode)referenceNode);
                    KimlUtil.toRelative((KVector)sourcePoint, (KNode)kedge.getSource().getParent());
                    KShapeLayout kShapeLayout = (KShapeLayout)kedge.getSourcePort().getData(KShapeLayout.class);
                    sourceLayout = (KShapeLayout)kedge.getSource().getData(KShapeLayout.class);
                    kShapeLayout.setXpos((float)sourcePoint.x - sourceLayout.getXpos() - kShapeLayout.getWidth() / 2.0f);
                    kShapeLayout.setYpos((float)sourcePoint.y - sourceLayout.getYpos() - kShapeLayout.getHeight() / 2.0f);
                }
                if (kedge.getTargetPort() != null) {
                    KimlUtil.toAbsolute((KVector)targetPoint, (KNode)referenceNode);
                    KimlUtil.toRelative((KVector)targetPoint, (KNode)kedge.getTarget().getParent());
                    KShapeLayout kShapeLayout = (KShapeLayout)kedge.getTargetPort().getData(KShapeLayout.class);
                    targetLayout = (KShapeLayout)kedge.getTarget().getData(KShapeLayout.class);
                    kShapeLayout.setXpos((float)targetPoint.x - targetLayout.getXpos() - kShapeLayout.getWidth() / 2.0f);
                    kShapeLayout.setYpos((float)targetPoint.y - targetLayout.getYpos() - kShapeLayout.getHeight() / 2.0f);
                }
            }
        }
        if (((Boolean)transData.getProperty(USE_SPLINES)).booleanValue()) {
            edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
        if ((labelPos = attributeMap.get("lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.CENTER, offset);
        }
        if ((labelPos = attributeMap.get("head_lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.HEAD, offset);
        }
        if ((labelPos = attributeMap.get("tail_lp")) != null) {
            this.applyEdgeLabelPos(kedge, labelPos, EdgeLabelPlacement.TAIL, offset);
        }
    }

    private void applyEdgeLabelPos(KEdge kedge, String posString, EdgeLabelPlacement placement, KVector offset) {
        float combinedWidth = 0.0f;
        float combinedHeight = 0.0f;
        for (KLabel label : kedge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            if (labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) != placement) continue;
            combinedWidth = Math.max(combinedWidth, labelLayout.getWidth());
            combinedHeight += labelLayout.getHeight();
        }
        try {
            KVector pos = new KVector();
            pos.parse(posString);
            float xpos = (float)(pos.x - (double)(combinedWidth / 2.0f) + offset.x);
            float ypos = (float)(pos.y - (double)(combinedHeight / 2.0f) + offset.y);
            for (KLabel label : kedge.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) != placement) continue;
                float xoffset = (combinedWidth - labelLayout.getWidth()) / 2.0f;
                labelLayout.setXpos(xpos + xoffset);
                labelLayout.setYpos(ypos);
                ypos += labelLayout.getHeight();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private static Map<String, String> createAttributeMap(List<Attribute> attributes) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeMap.put(attribute.getName(), attribute.getValue());
        }
        return attributeMap;
    }

    private static Pair<KVector, KVector> parseSplinePoints(String posString, List<KVectorChain> splines, KVector offset) {
        KVector sourcePoint = null;
        KVector targetPoint = null;
        StringTokenizer splinesTokenizer = new StringTokenizer(posString, "\";");
        while (splinesTokenizer.hasMoreTokens()) {
            KVectorChain pointList = new KVectorChain();
            StringTokenizer posTokenizer = new StringTokenizer(splinesTokenizer.nextToken(), " \t");
            while (posTokenizer.hasMoreTokens()) {
                String token = posTokenizer.nextToken();
                try {
                    if (token.startsWith("s")) {
                        if (sourcePoint != null) continue;
                        sourcePoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        sourcePoint.parse(token.substring(commaIndex + 1));
                        sourcePoint.add(offset);
                        continue;
                    }
                    if (token.startsWith("e")) {
                        if (targetPoint != null) continue;
                        targetPoint = new KVector();
                        int commaIndex = token.indexOf(44);
                        targetPoint.parse(token.substring(commaIndex + 1));
                        targetPoint.add(offset);
                        continue;
                    }
                    KVector point = new KVector();
                    point.parse(token);
                    pointList.add((Object)point.add(offset));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            splines.add(pointList);
        }
        return new Pair(sourcePoint, targetPoint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        NODE,
        CLUSTER,
        DUMMY;

    }
}

