/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.IntegerDistribution;
import org.eclipse.escet.common.java.Strings;

public class GeometricDistribution
extends IntegerDistribution {
    private final CifRandomGenerator randGen;
    private final double p;

    public GeometricDistribution(CifRandomGenerator randGen, double p) {
        this.randGen = randGen;
        this.p = p;
        if (p <= 0.0 || p > 1.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The chance parameter is not in the range (0.0 .. 1.0].";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private GeometricDistribution(GeometricDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.p = distribution.p;
    }

    @Override
    public IntegerDistribution copy() {
        return new GeometricDistribution(this);
    }

    @Override
    public int sample() {
        double a = 1.0 / Math.log(1.0 - this.p);
        return (int)(a * Math.log(this.randGen.drawNonZero()));
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"geometric(%s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.p)});
    }
}

