/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class GridFigure
extends Shape {
    private static final Rectangle INNER_FIGURE_BOUNDS = new Rectangle();
    private int[] myHeights;
    private int[] myWidths;
    private IFigure[][] myGrid;
    private Color myInnerFigureColor;
    private GridLayout myGridLayout;

    public GridFigure(int[] heights, int[] widths) {
        this.myHeights = new int[heights.length - 1];
        System.arraycopy(heights, 0, this.myHeights, 0, this.myHeights.length);
        this.myWidths = widths;
    }

    public GridFigure(IFigure[][] grid, int[] heights, int[] widths, GridLayout gridLayout) {
        this(heights, widths);
        this.myGrid = grid;
        this.myGridLayout = gridLayout;
    }

    public void setInnerFigureBoundsColor(Color color) {
        this.myInnerFigureColor = color;
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.SINGLETON;
        r.x = this.getBounds().x + inset1 + this.myGridLayout.marginWidth;
        r.y = this.getBounds().y + inset1 + this.myGridLayout.marginHeight;
        int acc = 0;
        int i = 0;
        while (i < this.myWidths.length) {
            acc += this.myWidths[i] + this.myGridLayout.horizontalSpacing;
            ++i;
        }
        r.width = Math.min(acc, this.getBounds().width - inset1 - inset2);
        acc = 0;
        i = 0;
        while (i < this.myHeights.length) {
            acc += this.myHeights[i] + this.myGridLayout.verticalSpacing;
            ++i;
        }
        r.height = Math.min(acc, this.getBounds().height - inset1 - inset2);
        graphics.drawRectangle(r);
        acc = r.y - this.myGridLayout.verticalSpacing / 2;
        i = 0;
        while (i < this.myHeights.length - 1) {
            graphics.drawLine(r.x, acc += this.myHeights[i] + this.myGridLayout.verticalSpacing, r.right(), acc);
            ++i;
        }
        acc = r.x - this.myGridLayout.horizontalSpacing / 2;
        i = 0;
        while (i < this.myWidths.length - 1) {
            graphics.drawLine(acc += this.myWidths[i] + this.myGridLayout.horizontalSpacing, r.y, acc, r.bottom());
            ++i;
        }
        i = 0;
        while (i < this.myHeights.length) {
            int j = 0;
            while (j < this.myWidths.length) {
                if (this.myGrid[i][j] == null || i > 0 && this.myGrid[i - 1][j] == this.myGrid[i][j]) {
                    ++j;
                    continue;
                }
                int width = 1;
                while (j + width < this.myWidths.length && this.myGrid[i][j] == this.myGrid[i][j + width]) {
                    ++width;
                }
                int height = 1;
                while (j + height < this.myHeights.length && this.myGrid[i][j] == this.myGrid[i + height][j]) {
                    ++height;
                }
                this.drawInnerFigureBounds(graphics, r, i, j, width, height);
                j += width;
            }
            ++i;
        }
    }

    private void drawInnerFigureBounds(Graphics graphics, Rectangle figureBounds, int row, int column, int width, int height) {
        graphics.pushState();
        if (this.myInnerFigureColor != null) {
            graphics.setForegroundColor(this.myInnerFigureColor);
        }
        GridFigure.INNER_FIGURE_BOUNDS.x = figureBounds.x - this.myGridLayout.horizontalSpacing / 2;
        int k = 0;
        while (k < column) {
            GridFigure.INNER_FIGURE_BOUNDS.x += this.myWidths[k] + this.myGridLayout.horizontalSpacing;
            ++k;
        }
        GridFigure.INNER_FIGURE_BOUNDS.width = 0;
        k = column;
        while (k < column + width) {
            GridFigure.INNER_FIGURE_BOUNDS.width += this.myWidths[k] + this.myGridLayout.horizontalSpacing;
            ++k;
        }
        GridFigure.INNER_FIGURE_BOUNDS.y = figureBounds.y - this.myGridLayout.verticalSpacing / 2;
        k = 0;
        while (k < row) {
            GridFigure.INNER_FIGURE_BOUNDS.y += this.myHeights[k] + this.myGridLayout.verticalSpacing;
            ++k;
        }
        GridFigure.INNER_FIGURE_BOUNDS.height = 0;
        k = row;
        while (k < row + height) {
            GridFigure.INNER_FIGURE_BOUNDS.height += this.myHeights[k] + this.myGridLayout.verticalSpacing;
            ++k;
        }
        graphics.drawRoundRectangle(INNER_FIGURE_BOUNDS, 10, 10);
        graphics.popState();
    }
}

