/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.core.IterationOrder;

class CompositeEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeEngineExecutionListener.class);
    private final List<EngineExecutionListener> engineExecutionListeners;

    CompositeEngineExecutionListener(List<EngineExecutionListener> engineExecutionListeners) {
        this.engineExecutionListeners = new ArrayList<EngineExecutionListener>(engineExecutionListeners);
    }

    @Override
    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        CompositeEngineExecutionListener.notifyEach(this.engineExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.dynamicTestRegistered(testDescriptor), () -> "dynamicTestRegistered(" + testDescriptor + ")");
    }

    @Override
    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        CompositeEngineExecutionListener.notifyEach(this.engineExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.executionSkipped(testDescriptor, reason), () -> "executionSkipped(" + testDescriptor + ", " + reason + ")");
    }

    @Override
    public void executionStarted(TestDescriptor testDescriptor) {
        CompositeEngineExecutionListener.notifyEach(this.engineExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.executionStarted(testDescriptor), () -> "executionStarted(" + testDescriptor + ")");
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        CompositeEngineExecutionListener.notifyEach(this.engineExecutionListeners, IterationOrder.REVERSED, listener -> listener.executionFinished(testDescriptor, testExecutionResult), () -> "executionFinished(" + testDescriptor + ", " + testExecutionResult + ")");
    }

    @Override
    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        CompositeEngineExecutionListener.notifyEach(this.engineExecutionListeners, IterationOrder.ORIGINAL, listener -> listener.reportingEntryPublished(testDescriptor, entry), () -> "reportingEntryPublished(" + testDescriptor + ", " + entry + ")");
    }

    private static <T extends EngineExecutionListener> void notifyEach(List<T> listeners, IterationOrder iterationOrder, Consumer<T> consumer, Supplier<String> description) {
        iterationOrder.forEach(listeners, listener -> {
            try {
                consumer.accept(listener);
            }
            catch (Throwable throwable) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
                logger.warn(throwable, () -> CompositeEngineExecutionListener.lambda$notifyEach$10(listener, (Supplier)description));
            }
        });
    }

    private static /* synthetic */ String lambda$notifyEach$10(EngineExecutionListener listener, Supplier description) {
        return String.format("EngineExecutionListener [%s] threw exception for method: %s", listener.getClass().getName(), description.get());
    }
}

