/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;

public class QueryEngineTDB
extends QueryEngineMain {
    protected static QueryEngineFactory factory = new QueryEngineFactoryTDB();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    protected QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context2) {
        super(op, (DatasetGraph)dataset, input, context2);
    }

    protected QueryEngineTDB(Query query, DatasetGraphTDB dataset, Binding input, Context cxt) {
        super(query, (DatasetGraph)dataset, input, cxt);
    }

    @Override
    protected DatasetGraph dynamicDataset(DatasetDescription dsDesc, DatasetGraph dataset, boolean unionDftGraph) {
        boolean union = unionDftGraph || this.context.isTrue(TDB1.symUnionDefaultGraph);
        return DynamicDatasets.dynamicDataset(dsDesc, dataset, union);
    }

    @Override
    protected Op modifyOp(Op op) {
        op = Substitute.substitute(op, this.getStartBinding());
        op = super.modifyOp(op);
        if (!this.isDynamicDataset()) {
            op = Algebra.toQuadForm(op);
        }
        this.setOp(op);
        return op;
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context2) {
        if (context2.isTrue(TDB1.symUnionDefaultGraph) && !this.isDynamicDataset()) {
            op = OpLib.unionDefaultGraphQuads(op);
            Explain.explain("REWRITE(Union default graph)", op, context2);
        }
        QueryIterator results = super.eval(op, dsg, input, context2);
        return results;
    }

    protected static class QueryEngineFactoryTDB
    implements QueryEngineFactory {
        protected QueryEngineFactoryTDB() {
        }

        private static boolean isHandledByTDB(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return true;
            }
            return dataset instanceof DatasetGraphTransaction;
        }

        protected DatasetGraphTDB dsgToQuery(DatasetGraph dataset) {
            if (dataset instanceof DatasetGraphTDB) {
                return (DatasetGraphTDB)dataset;
            }
            if (dataset instanceof DatasetGraphTransaction) {
                DatasetGraphTransaction dsgtxn = (DatasetGraphTransaction)dataset;
                return dsgtxn.getDatasetGraphToQuery();
            }
            throw new TDB1Exception("Internal inconsistency: trying to execute query on unrecognized kind of DatasetGraph: " + Lib.className(dataset));
        }

        @Override
        public boolean accept(Query query, DatasetGraph dataset, Context context2) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        @Override
        public Plan create(Query query, DatasetGraph dataset, Binding input, Context context2) {
            QueryEngineTDB engine = new QueryEngineTDB(query, this.dsgToQuery(dataset), input, context2);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context2) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context2) {
            QueryEngineTDB engine = new QueryEngineTDB(op, this.dsgToQuery(dataset), binding, context2);
            return engine.getPlan();
        }
    }
}

