/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.exec.http.Service;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.util.Context;

@Deprecated(forRemoval=true, since="4.6.0")
public class QueryIterService
extends QueryIterRepeatApply {
    protected OpService opService;

    public QueryIterService(QueryIterator input, OpService opService, ExecutionContext execCxt) {
        super(input, execCxt);
        Service.checkServiceAllowed(execCxt.getContext());
        this.opService = opService;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        boolean silent = this.opService.getSilent();
        ExecutionContext execCxt = this.getExecContext();
        Context cxt = execCxt.getContext();
        ServiceExecutorRegistry registry = ServiceExecutorRegistry.get(cxt);
        QueryIterator svcExec = null;
        OpService substitutedOp = (OpService)QC.substitute(this.opService, outerBinding);
        try {
            if (registry != null) {
                for (ChainingServiceExecutor factory : registry.getSingleChain()) {
                    if (factory == null) {
                        Log.warn(this, "SERVICE <" + this.opService.getService().toString() + ">: Null item in custom ServiceExecutionRegistry");
                        continue;
                    }
                    svcExec = factory.createExecution(substitutedOp, this.opService, outerBinding, execCxt, null);
                    if (svcExec == null) continue;
                    break;
                }
            }
            if (svcExec == null) {
                throw new QueryExecException("No SERVICE handler");
            }
            QueryIter qIter = QueryIter.makeTracked(svcExec, this.getExecContext());
            return new QueryIterCommonParent((QueryIterator)qIter, outerBinding, this.getExecContext());
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn(this, "SERVICE " + NodeFmtLib.strTTL(substitutedOp.getService()) + " : " + ex.getMessage());
                return QueryIterSingleton.create(outerBinding, this.getExecContext());
            }
            throw ex;
        }
    }
}

