/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public class ExportWorkspaceController
implements IExportImportController {
    public String getLabel() {
        return "workspace";
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore Workspace Files (*" + ExportImportDataUnits.Workspace.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Workspace.getExtension() + ", *.*"};
    }

    public String getFilename() {
        return "Workspace_" + new Date();
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.exportWorkSpacePath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        if (!FileUtil.getExtension((File)file).equals(ExportImportDataUnits.Workspace.getExtension())) {
            file = new File(file.getAbsoluteFile() + ExportImportDataUnits.Workspace.getExtension());
        }
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        Workspace copy = (Workspace)ModelUtil.clone((EObject)((Workspace)workspace.toInternalAPI()));
        int i = 0;
        for (ProjectSpace copiedProjectSpace : copy.getProjectSpaces()) {
            Project orgProject = ((ProjectSpace)((Workspace)workspace.toInternalAPI()).getProjectSpaces().get(i++)).getProject();
            copiedProjectSpace.setProject((Project)ModelUtil.clone((EObject)orgProject));
        }
        ResourceHelper.putWorkspaceIntoNewResource(file.getAbsolutePath(), copy);
    }

    public boolean isExport() {
        return true;
    }
}

