/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabContent {
    private TableViewer tableViewer;
    private String tabName;
    private TabContent tab;
    private AdminBroker adminBroker;
    private PropertiesForm form;

    public TabContent(String tabName, AdminBroker adminBroker, PropertiesForm frm) {
        this.tabName = tabName;
        this.adminBroker = adminBroker;
        this.form = frm;
    }

    protected Composite createContents(TabFolder tabFolder) {
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayoutData((Object)new GridData(4, 4, true, true));
        tabContent.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(tabContent, 0x820000);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.initList(tabContent);
        List<Action> actions = this.initActions();
        if (actions.size() > 0) {
            for (Action action : actions) {
                toolBarManager.add((IAction)action);
            }
            toolBarManager.update(true);
        }
        return tabContent;
    }

    protected abstract List<Action> initActions();

    protected void initList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        container.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(container, 65794);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        column.getColumn().setResizable(false);
        column.getColumn().setMoveable(false);
        this.tableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.tableViewer.setInput(new Object());
        this.tableViewer.getTable().setSortColumn(this.tableViewer.getTable().getColumn(0));
        this.tableViewer.getTable().setSortDirection(128);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int dir = TabContent.this.tableViewer.getTable().getSortDirection();
                dir = dir == 128 ? 1024 : 128;
                TabContent.this.tableViewer.getTable().setSortDirection(dir);
                TabContent.this.tableViewer.setSorter((ViewerSorter)new SimpleAlphabeticSorter(dir));
            }
        };
        column.getColumn().addListener(13, sortListener);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TabContent.this.form.setInput(TabContent.this.getSelectedItem(event));
            }
        });
        this.addDragNDropSupport();
    }

    public abstract ITableLabelProvider getLabelProvider();

    public abstract IStructuredContentProvider getContentProvider();

    public void selectFirstElement() {
        this.form.setInput((EObject)this.tableViewer.getElementAt(0));
        this.tableViewer.getTable().setSelection(0);
    }

    private void addDragNDropSupport() {
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceListener dragListener = new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                PropertiesForm.setDragNDropObject(null);
                PropertiesForm.setDragSource("");
            }

            public void dragStart(DragSourceEvent event) {
                PropertiesForm.setDragSource(TabContent.this.getName());
            }

            public void dragSetData(DragSourceEvent event) {
                EObject eObject = TabContent.this.getSelectedItem(null);
                if (eObject != null && eObject instanceof ACOrgUnit) {
                    ACOrgUnit orgUnit = (ACOrgUnit)eObject;
                    PropertiesForm.setDragNDropObject((EObject)orgUnit);
                }
            }
        };
        this.tableViewer.addDragSupport(ops, transfers, dragListener);
        ops = 2;
        DropTargetListener dropListener = new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                if (PropertiesForm.getDragNDropObject() instanceof ACOrgUnit) {
                    TabContent.this.doDrop((ACOrgUnit)PropertiesForm.getDragNDropObject());
                    PropertiesForm.setDragNDropObject(null);
                }
            }

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
        this.tableViewer.addDropSupport(ops, transfers, dropListener);
    }

    private void doDrop(ACOrgUnit orgUnit) {
        EObject currentInput = this.form.getCurrentInput();
        if (currentInput == null) {
            return;
        }
        try {
            if (currentInput instanceof ProjectInfo) {
                ProjectInfo projectInfo = (ProjectInfo)currentInput;
                this.adminBroker.removeParticipant(projectInfo.getProjectId(), orgUnit.getId());
            } else if (currentInput instanceof ACGroup) {
                ACGroup group = (ACGroup)currentInput;
                this.adminBroker.removeMember(group.getId(), orgUnit.getId());
            } else if (currentInput instanceof ACUser) {
                ACUser user = (ACUser)currentInput;
                this.adminBroker.removeGroup(user.getId(), ((ACGroup)orgUnit).getId());
            }
        }
        catch (AccessControlException accessControlException) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TabContent_Insufficient_Access_Rights, (String)Messages.TabContent_Not_Allowed_To_Remove_OrgUnit);
        }
        catch (ESException ex) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
        }
    }

    private String getName() {
        return this.tabName;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private EObject getSelectedItem(SelectionChangedEvent event) {
        ProjectInfo result = null;
        ISelection sel = event != null ? event.getSelection() : this.tableViewer.getSelection();
        IStructuredSelection ssel = null;
        if (sel != null) {
            ssel = (IStructuredSelection)sel;
        }
        if (ssel != null) {
            Object obj = ssel.getFirstElement();
            if (obj instanceof ProjectInfo) {
                result = (ProjectInfo)obj;
            } else if (obj instanceof ACOrgUnit) {
                result = (ACOrgUnit)obj;
            }
        }
        return result;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public TabContent getTab() {
        return this.tab;
    }

    public void setTab(TabContent tab) {
        this.tab = tab;
    }

    public AdminBroker getAdminBroker() {
        return this.adminBroker;
    }

    public void setAdminBroker(AdminBroker adminBroker) {
        this.adminBroker = adminBroker;
    }

    public PropertiesForm getForm() {
        return this.form;
    }

    public void setForm(PropertiesForm form) {
        this.form = form;
    }

    public void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private final class SimpleAlphabeticSorter
    extends ViewerSorter {
        private int dir = 128;

        public SimpleAlphabeticSorter(int dir) {
            this.dir = dir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int returnValue = 0;
            if (e1 instanceof ProjectInfo) {
                ProjectInfo pi1 = (ProjectInfo)e1;
                ProjectInfo pi2 = (ProjectInfo)e2;
                returnValue = pi1.getName().compareTo(pi2.getName());
            }
            if (e1 instanceof ACUser) {
                ACUser u1 = (ACUser)e1;
                ACUser u2 = (ACUser)e2;
                returnValue = u1.getName().compareTo(u2.getName());
            }
            if (e1 instanceof ACGroup) {
                ACGroup g1 = (ACGroup)e1;
                ACGroup g2 = (ACGroup)e2;
                returnValue = g1.getName().compareTo(g2.getName());
            }
            if (this.dir == 1024) {
                returnValue *= -1;
            }
            return returnValue;
        }
    }
}

