/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.util;

import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public final class EMFStoreClientUtil {
    private static final String LOCALHOST_GENERATED_ENTRY_NAME = "EMFStore (generated entry)";

    private EMFStoreClientUtil() {
    }

    public static ServerInfo giveServerInfo(String url, int port) {
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        for (ServerInfo existingServerInfo : ((Workspace)workspace.toInternalAPI()).getServerInfos()) {
            if (!existingServerInfo.getName().equals(LOCALHOST_GENERATED_ENTRY_NAME) || !url.equals(existingServerInfo.getUrl()) || port != existingServerInfo.getPort()) continue;
            return existingServerInfo;
        }
        ServerInfo serverInfo = EMFStoreClientUtil.createServerInfo(url, port, null);
        ((Workspace)workspace.toInternalAPI()).getServerInfos().add((Object)serverInfo);
        ((WorkspaceBase)workspace.toInternalAPI()).save();
        return serverInfo;
    }

    public static ServerInfo createServerInfo(String url, int port, String certificateAlias) {
        ServerInfo serverInfo = ModelFactory.eINSTANCE.createServerInfo();
        serverInfo.setName(LOCALHOST_GENERATED_ENTRY_NAME);
        serverInfo.setUrl(url);
        serverInfo.setPort(port);
        if (certificateAlias == null) {
            serverInfo.setCertificateAlias("emfstore test certificate (do not use in production!)");
        } else {
            serverInfo.setCertificateAlias(certificateAlias);
        }
        return serverInfo;
    }

    public static Usersession createUsersession() {
        return EMFStoreClientUtil.createUsersession("super", "super", "localhost", 8080);
    }

    public static Usersession createUsersession(String username, String password, String serverUrl, int serverPort) {
        Usersession usersession2;
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        for (Usersession usersession2 : ((Workspace)workspace.toInternalAPI()).getUsersessions()) {
            ServerInfo existingServerInfo = usersession2.getServerInfo();
            if (existingServerInfo == null || !existingServerInfo.getName().equals(LOCALHOST_GENERATED_ENTRY_NAME) || !existingServerInfo.getUrl().equals(serverUrl) || existingServerInfo.getPort() != serverPort) continue;
            String encPassword = KeyStoreManager.getInstance().encrypt(password, existingServerInfo);
            if (!username.equals(usersession2.getUsername()) || !encPassword.equals(usersession2.getPassword())) continue;
            return usersession2;
        }
        usersession2 = ModelFactory.eINSTANCE.createUsersession();
        usersession2.setServerInfo(EMFStoreClientUtil.giveServerInfo(serverUrl, serverPort));
        usersession2.setUsername(username);
        usersession2.setPassword(password);
        ((Workspace)workspace.toInternalAPI()).getUsersessions().add((Object)usersession2);
        ((WorkspaceBase)workspace.toInternalAPI()).save();
        return usersession2;
    }

    public static boolean dryLogin(String username, String password, String serverUrl, int serverPort, String certificateAlias) throws ESException {
        Usersession usersession = ModelFactory.eINSTANCE.createUsersession();
        usersession.setServerInfo(EMFStoreClientUtil.createServerInfo(serverUrl, serverPort, certificateAlias));
        usersession.setUsername(username);
        usersession.setPassword(password);
        try {
            usersession.logIn();
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
        return true;
    }

    public static boolean areEqual(ESLocalProject projectA, ESLocalProject projectB) {
        ProjectSpace projectSpaceA = (ProjectSpace)((ESLocalProjectImpl)projectA).toInternalAPI();
        ProjectSpace projectSpaceB = (ProjectSpace)((ESLocalProjectImpl)projectB).toInternalAPI();
        return ModelUtil.areEqual((IdEObjectCollection)projectSpaceA.getProject(), (IdEObjectCollection)projectSpaceB.getProject());
    }
}

