/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictHandler;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.AttributeConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.CompositeConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.DeletionConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiAttributeConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiAttributeMoveConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiAttributeMoveSetConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiAttributeSetConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiAttributeSetSetConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceSetConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceSetSetConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceSetSingleConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceSingleConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.ReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.ChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionManager {
    private final ConflictHandler conflictHandler;
    private ArrayList<VisualConflict> conflicts;
    private final ConflictDetector conflictDetector;
    private final ChangeConflictSet changeConflictSet;
    private final ModelElementIdToEObjectMapping mapping;
    private final boolean isBranchMerge;
    private final Project project;
    private Set<ConflictBucket> unvisualizedConflicts;
    private Integer myLeafOperationCount;
    private Integer theirLeafOperationCount;
    private Integer myOperationCount;
    private Integer theirOperationCount;

    public DecisionManager(Project project, ChangeConflictSet changeConflict, boolean isBranchMerge) {
        this.project = project;
        this.mapping = changeConflict.getIdToEObjectMapping();
        this.isBranchMerge = isBranchMerge;
        this.changeConflictSet = changeConflict;
        this.conflictHandler = this.initConflictHandlers();
        this.conflictDetector = new ConflictDetector();
        this.init();
    }

    private ConflictHandler initConflictHandlers() {
        return (ConflictHandler)ExtensionRegistry.INSTANCE.get("org.eclipse.emfstore.client.changeTracking.merging.conflictHandler", ConflictHandler.class, (Object)new ConflictHandler(){

            public VisualConflict handle(VisualConflict conflict, ModelElementIdToEObjectMapping idToEObjectMapping) {
                return conflict;
            }
        }, true);
    }

    private void init() {
        this.conflicts = new ArrayList();
        this.unvisualizedConflicts = new LinkedHashSet<ConflictBucket>();
        Set conflictBuckets = this.changeConflictSet.getConflictBuckets();
        this.createConflicts(conflictBuckets);
    }

    private void createConflicts(Set<ConflictBucket> conflictBucket) {
        for (ConflictBucket conf : conflictBucket) {
            AbstractOperation my = conf.getMyOperation();
            AbstractOperation their = conf.getTheirOperation();
            VisualConflict conflict = null;
            if (OperationUtil.isAttribute((AbstractOperation)my) && OperationUtil.isAttribute((AbstractOperation)their)) {
                conflict = this.createAttributeAttributeDecision(conf);
            } else if (OperationUtil.isSingleRef((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their)) {
                conflict = this.createSingleSingleConflict(conf);
            } else if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isMultiRef((AbstractOperation)their)) {
                conflict = this.createMultiMultiConflict(conf);
            } else if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their) || OperationUtil.isMultiRef((AbstractOperation)their) && OperationUtil.isSingleRef((AbstractOperation)my)) {
                conflict = this.createMultiSingle(conf);
            } else if (OperationUtil.isMultiRef((AbstractOperation)my) && OperationUtil.isMultiRefSet((AbstractOperation)their) || OperationUtil.isMultiRef((AbstractOperation)their) && OperationUtil.isMultiRefSet((AbstractOperation)my)) {
                conflict = this.createMultiRefMultiSet(conf);
            } else if (OperationUtil.isMultiRefSet((AbstractOperation)my) && OperationUtil.isMultiRefSet((AbstractOperation)their)) {
                conflict = this.createMultiRefSetSet(conf);
            } else if (OperationUtil.isMultiRefSet((AbstractOperation)my) && OperationUtil.isSingleRef((AbstractOperation)their) || OperationUtil.isMultiRefSet((AbstractOperation)their) && OperationUtil.isSingleRef((AbstractOperation)my)) {
                conflict = this.createMultiSetSingle(conf);
            } else if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAtt((AbstractOperation)their)) {
                conflict = this.createMultiAtt(conf);
            } else if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAttSet((AbstractOperation)their) || OperationUtil.isMultiAtt((AbstractOperation)their) && OperationUtil.isMultiAttSet((AbstractOperation)my)) {
                conflict = this.createMultiAttSet(conf);
            } else if (OperationUtil.isMultiAtt((AbstractOperation)my) && OperationUtil.isMultiAttMove((AbstractOperation)their) || OperationUtil.isMultiAtt((AbstractOperation)their) && OperationUtil.isMultiAttMove((AbstractOperation)my)) {
                conflict = this.createMultiAttMove(conf);
            } else if (OperationUtil.isMultiAttSet((AbstractOperation)my) && OperationUtil.isMultiAttMove((AbstractOperation)their) || OperationUtil.isMultiAttSet((AbstractOperation)their) && OperationUtil.isMultiAttMove((AbstractOperation)my)) {
                conflict = this.createMultiAttMoveSet(conf);
            } else if (OperationUtil.isMultiAttSet((AbstractOperation)my) && OperationUtil.isMultiAttSet((AbstractOperation)their)) {
                conflict = this.createMultiAttSetSet(conf);
            } else if (OperationUtil.isComposite((AbstractOperation)my) || OperationUtil.isComposite((AbstractOperation)their)) {
                conflict = this.createCompositeConflict(conf);
            } else if (OperationUtil.isDelete((AbstractOperation)my) || OperationUtil.isDelete((AbstractOperation)their)) {
                conflict = this.createDeleteOtherConflict(conf);
            } else if (OperationUtil.isCompositeWithMain((AbstractOperation)my) || OperationUtil.isCompositeWithMain((AbstractOperation)their)) {
                conflict = this.createCompositeConflict(conf);
            }
            if (conflict != null) {
                conflict = this.notifyConflictHandlers(conflict);
                this.addConflict(conflict);
                continue;
            }
            this.unvisualizedConflicts.add(conf);
            WorkspaceUtil.log("A created conflict has been ignored (does not apply to any existing conflict rule).", 2);
        }
    }

    private VisualConflict notifyConflictHandlers(VisualConflict conflict) {
        return this.conflictHandler.handle(conflict, this.mapping);
    }

    private void addConflict(VisualConflict conflict) {
        if (conflict == null) {
            return;
        }
        this.conflicts.add(conflict);
    }

    private VisualConflict createMultiRefMultiSet(ConflictBucket conf) {
        if (OperationUtil.isMultiRef((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSetConflict(conf, this, true);
        }
        return new MultiReferenceSetConflict(conf, this, false);
    }

    private VisualConflict createMultiSetSingle(ConflictBucket conf) {
        if (OperationUtil.isMultiRefSet((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSetSingleConflict(conf, this, true);
        }
        return new MultiReferenceSetSingleConflict(conf, this, false);
    }

    private VisualConflict createMultiSingle(ConflictBucket conf) {
        if (OperationUtil.isMultiRef((AbstractOperation)conf.getMyOperation())) {
            return new MultiReferenceSingleConflict(conf, this, true);
        }
        return new MultiReferenceSingleConflict(conf, this, false);
    }

    private VisualConflict createMultiRefSetSet(ConflictBucket conf) {
        return new MultiReferenceSetSetConflict(conf, this);
    }

    private VisualConflict createMultiAttSetSet(ConflictBucket conf) {
        return new MultiAttributeSetSetConflict(conf, this);
    }

    private VisualConflict createMultiAtt(ConflictBucket conf) {
        if (((MultiAttributeOperation)conf.getMyOperation()).isAdd()) {
            return new MultiAttributeConflict(conf, this, true);
        }
        return new MultiAttributeConflict(conf, this, false);
    }

    private VisualConflict createMultiAttSet(ConflictBucket conf) {
        if (OperationUtil.isMultiAtt((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeSetConflict(conf, this, true);
        }
        return new MultiAttributeSetConflict(conf, this, false);
    }

    private VisualConflict createMultiAttMove(ConflictBucket conf) {
        if (OperationUtil.isMultiAtt((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeMoveConflict(conf, this, true);
        }
        return new MultiAttributeMoveConflict(conf, this, false);
    }

    private VisualConflict createMultiAttMoveSet(ConflictBucket conf) {
        if (OperationUtil.isMultiAttSet((AbstractOperation)conf.getMyOperation())) {
            return new MultiAttributeMoveSetConflict(conf, this, true);
        }
        return new MultiAttributeMoveSetConflict(conf, this, false);
    }

    private VisualConflict createReferenceCompVSSingleMulti(ConflictBucket conf) {
        if (OperationUtil.isCompositeRef((AbstractOperation)conf.getMyOperation())) {
            return this.createRefFromSub(conf, (List<AbstractOperation>)((CompositeOperation)conf.getMyOperation()).getSubOperations(), Arrays.asList(conf.getTheirOperation()));
        }
        return this.createRefFromSub(conf, Arrays.asList(conf.getMyOperation()), (List<AbstractOperation>)((CompositeOperation)conf.getTheirOperation()).getSubOperations());
    }

    private VisualConflict createReferenceConflict(ConflictBucket conf) {
        EList myOperations = ((CompositeOperation)conf.getMyOperation()).getSubOperations();
        EList theirOperations = ((CompositeOperation)conf.getTheirOperation()).getSubOperations();
        return this.createRefFromSub(conf, (List<AbstractOperation>)myOperations, (List<AbstractOperation>)theirOperations);
    }

    private VisualConflict createRefFromSub(ConflictBucket conf, List<AbstractOperation> myOperations, List<AbstractOperation> theirOperations) {
        Iterator<AbstractOperation> iterator = myOperations.iterator();
        if (iterator.hasNext()) {
            AbstractOperation myOp = iterator.next();
            if (OperationUtil.isSingleRef((AbstractOperation)myOp)) {
                return new ReferenceConflict(true, conf, this);
            }
            if (OperationUtil.isMultiRef((AbstractOperation)myOp)) {
                return new ReferenceConflict(false, conf, this);
            }
            return null;
        }
        return null;
    }

    private VisualConflict createAttributeAttributeDecision(ConflictBucket conf) {
        return new AttributeConflict(conf, this);
    }

    private VisualConflict createSingleSingleConflict(ConflictBucket conf) {
        return new SingleReferenceConflict(conf, this);
    }

    private VisualConflict createMultiMultiConflict(ConflictBucket conf) {
        if (((MultiReferenceOperation)conf.getMyOperation()).isAdd()) {
            return new MultiReferenceConflict(conf, this, true);
        }
        return new MultiReferenceConflict(conf, this, false);
    }

    private VisualConflict createDeleteOtherConflict(ConflictBucket conf) {
        if (OperationUtil.isDelete((AbstractOperation)conf.getMyOperation())) {
            return new DeletionConflict(conf, true, this);
        }
        return new DeletionConflict(conf, false, this);
    }

    private VisualConflict createCompositeConflict(ConflictBucket conf) {
        if (OperationUtil.isComposite((AbstractOperation)conf.getMyOperation())) {
            return new CompositeConflict(conf, this, true);
        }
        return new CompositeConflict(conf, this, false);
    }

    public ArrayList<VisualConflict> getConflicts() {
        return this.conflicts;
    }

    public boolean isResolved() {
        boolean isResolved = true;
        for (VisualConflict conflict : this.conflicts) {
            boolean bl = isResolved = isResolved && conflict.isResolved();
        }
        return isResolved;
    }

    public void calcResult() {
        if (!this.isResolved()) {
            return;
        }
        for (VisualConflict conflict : this.conflicts) {
            conflict.resolve();
        }
        for (ConflictBucket conflictBucket : this.unvisualizedConflicts) {
            conflictBucket.resolveConflict(new LinkedHashSet(), new LinkedHashSet());
        }
    }

    public ConflictDetector getConflictDetector() {
        return this.conflictDetector;
    }

    public boolean isBranchMerge() {
        return this.isBranchMerge;
    }

    public String getModelElementName(ModelElementId modelElementId) {
        return this.getModelElementName(this.getModelElement(modelElementId));
    }

    public String getModelElementName(EObject modelElement) {
        return DecisionUtil.getModelElementName(modelElement);
    }

    public EObject getModelElement(ModelElementId modelElementId) {
        return this.mapping.get((Object)modelElementId);
    }

    public String getAuthorForOperation(AbstractOperation theirOperation) {
        return "";
    }

    public int countMyLeafOperations() {
        if (this.myLeafOperationCount == null) {
            this.countConflicts();
        }
        return this.myLeafOperationCount;
    }

    private void countConflicts() {
        int myCount = 0;
        int myLeafCount = 0;
        int theirCount = 0;
        int theirLeafCount = 0;
        for (VisualConflict conflict : this.conflicts) {
            myCount += conflict.getLeftOperations().size();
            myLeafCount += ChangePackageImpl.countLeafOperations(conflict.getMyOperations());
            theirCount += conflict.getRightOperations().size();
            theirLeafCount += ChangePackageImpl.countLeafOperations(conflict.getTheirOperations());
        }
        this.myOperationCount = myCount;
        this.myLeafOperationCount = myLeafCount;
        this.theirOperationCount = theirCount;
        this.theirLeafOperationCount = theirLeafCount;
    }

    public int countTheirLeafOperations() {
        if (this.theirLeafOperationCount == null) {
            this.countConflicts();
        }
        return this.theirLeafOperationCount;
    }

    public int countMyOperations() {
        if (this.myOperationCount == null) {
            this.countConflicts();
        }
        return this.myOperationCount;
    }

    public int countTheirOperations() {
        if (this.theirOperationCount == null) {
            this.countConflicts();
        }
        return this.theirOperationCount;
    }

    public ModelElementIdToEObjectMapping getIdToEObjectMapping() {
        return this.mapping;
    }

    public Project getProject() {
        return this.project;
    }
}

