/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.ISelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.OrthogonalSelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.PolylineSelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.SplineSelfLoopRouter;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class SelfLoopBendpointCalculator
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("SelfLoop Bendpoint Calculation", 1.0f);
        ISelfLoopRouter loopRouter = this.determineLoopRouter(layeredGraph);
        EdgeRouting routingStyle = (EdgeRouting)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING);
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                if (node.getType() != LNode.NodeType.NORMAL) continue;
                SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
                for (SelfLoopComponent component : slNode.getSelfLoopComponents()) {
                    for (SelfLoopEdge edge : component.getConnectedEdges()) {
                        loopRouter.routeSelfLoop(edge, slNode);
                    }
                    this.calculateJunctionPoints(component, routingStyle);
                }
            }
        }
        monitor.done();
    }

    private ISelfLoopRouter determineLoopRouter(LGraph layeredGraph) {
        switch ((EdgeRouting)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING)) {
            case ORTHOGONAL: {
                return new OrthogonalSelfLoopRouter();
            }
            case SPLINES: {
                return new SplineSelfLoopRouter();
            }
            case POLYLINE: {
                return new PolylineSelfLoopRouter();
            }
        }
        return new OrthogonalSelfLoopRouter();
    }

    private void calculateJunctionPoints(SelfLoopComponent component, EdgeRouting routingStyle) {
        for (SelfLoopPort port : component.getPorts()) {
            if (port.getDirection() != SelfLoopRoutingDirection.BOTH && (!port.isNonLoopPort() || component.getPorts().size() == 1)) continue;
            for (LEdge edge : port.getLPort().getConnectedEdges()) {
                KVectorChain bendpoints;
                KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    edge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
                }
                if ((bendpoints = edge.getBendPoints()).isEmpty()) continue;
                KVector jpoint = null;
                if (edge.getTarget() == port.getLPort()) {
                    int lastBendPoint = routingStyle == EdgeRouting.POLYLINE ? bendpoints.size() - 2 : bendpoints.size() - 1;
                    jpoint = new KVector((KVector)bendpoints.get(lastBendPoint));
                } else {
                    int firstBendPoint = routingStyle == EdgeRouting.POLYLINE ? 1 : 0;
                    jpoint = new KVector((KVector)bendpoints.get(firstBendPoint));
                }
                junctionPoints.add((Object)jpoint);
            }
        }
    }
}

