/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.json.JsonExporter;
import org.eclipse.elk.graph.json.JsonImportException;
import org.eclipse.elk.graph.json.JsonImporter;

public final class ElkGraphJson {
    private ElkGraphJson() {
    }

    public static ImportBuilder forGraph(String graph) {
        ImportBuilder ib = new ImportBuilder();
        ib.graph = graph;
        return ib;
    }

    public static ImportBuilder forGraph(JsonObject graph) {
        ImportBuilder ib = new ImportBuilder();
        ib.jsonGraph = graph;
        return ib;
    }

    public static ExportBuilder forGraph(ElkNode graph) {
        ExportBuilder eb = new ExportBuilder();
        eb.graph = graph;
        return eb;
    }

    public static final class ExportBuilder {
        private ElkNode graph;
        private boolean prettyPrint = false;
        private boolean omitZeroPosition = true;
        private boolean omitZeroDimension = true;
        private boolean omitLayoutInformation = false;
        private boolean shortLayoutOptionKeys = true;

        public ExportBuilder prettyPrint(boolean pretty) {
            this.prettyPrint = pretty;
            return this;
        }

        public ExportBuilder shortLayoutOptionKeys(boolean shortKeys) {
            this.shortLayoutOptionKeys = shortKeys;
            return this;
        }

        public ExportBuilder omitZeroPositions(boolean omitZeroPos) {
            this.omitZeroPosition = omitZeroPos;
            return this;
        }

        public ExportBuilder omitZeroDimension(boolean omitZeroDim) {
            this.omitZeroDimension = omitZeroDim;
            return this;
        }

        public ExportBuilder omitLayout(boolean omitLayout) {
            this.omitLayoutInformation = omitLayout;
            return this;
        }

        public String toJson() {
            JsonExporter exporter = new JsonExporter();
            exporter.setOptions(this.omitZeroPosition, this.omitZeroDimension, this.omitLayoutInformation, this.shortLayoutOptionKeys);
            JsonObject jsonGraph = exporter.export(this.graph);
            GsonBuilder builder = new GsonBuilder();
            if (this.prettyPrint) {
                builder.setPrettyPrinting();
            }
            Gson gson = builder.create();
            String json = gson.toJson((JsonElement)jsonGraph);
            return json;
        }
    }

    public static final class ImportBuilder {
        private JsonObject jsonGraph;
        private String graph;
        private Maybe<JsonImporter> importerMaybe;

        public ImportBuilder rememberImporter(Maybe<JsonImporter> maybe) {
            this.importerMaybe = maybe;
            return this;
        }

        public ElkNode toElk() {
            if (this.jsonGraph == null) {
                JsonParser parser = new JsonParser();
                JsonElement json = parser.parse(this.graph);
                if (!(json instanceof JsonObject)) {
                    throw new JsonImportException("Top-level element of the graph must be a json object.");
                }
                this.jsonGraph = json.getAsJsonObject();
            }
            JsonImporter importer = new JsonImporter();
            ElkNode elkGraph = importer.transform(this.jsonGraph);
            if (this.importerMaybe != null) {
                this.importerMaybe.set((Object)importer);
            }
            return elkGraph;
        }
    }
}

