/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphiti;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.graphiti.GraphitiDiagramLayoutConnector;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class GraphitiLayoutCommand
extends RecordingCommand {
    private final List<Pair<ElkGraphElement, PictogramElement>> elements = new LinkedList<Pair<ElkGraphElement, PictogramElement>>();
    private final IFeatureProvider featureProvider;
    private final Map<ElkEdge, KVectorChain> bendpointsMap = new HashMap<ElkEdge, KVectorChain>();
    private final GraphitiDiagramLayoutConnector layoutManager;

    public GraphitiLayoutCommand(TransactionalEditingDomain domain, IFeatureProvider thefeatureProvider, GraphitiDiagramLayoutConnector manager) {
        super(domain, "Automatic Layout");
        this.featureProvider = thefeatureProvider;
        this.layoutManager = manager;
    }

    protected IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void add(ElkGraphElement graphElement, PictogramElement pictogramElement) {
        this.elements.add((Pair<ElkGraphElement, PictogramElement>)new Pair((Object)graphElement, (Object)pictogramElement));
    }

    protected void doExecute() {
        for (Pair<ElkGraphElement, PictogramElement> entry : this.elements) {
            ElkGraphElement element = (ElkGraphElement)entry.getFirst();
            if (element instanceof ElkPort) {
                this.applyPortLayout((ElkPort)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof ElkNode) {
                this.applyNodeLayout((ElkNode)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (element instanceof ElkEdge) {
                this.applyEdgeLayout((ElkEdge)element, (PictogramElement)entry.getSecond());
                continue;
            }
            if (!(element instanceof ElkLabel) || !(((ElkLabel)element).eContainer() instanceof ElkEdge)) continue;
            this.applyEdgeLabelLayout((ElkLabel)element, (PictogramElement)entry.getSecond());
        }
        this.bendpointsMap.clear();
    }

    protected void applyPortLayout(ElkPort elkport, PictogramElement pelem) {
        this.applyPortLayout(elkport.getX(), elkport.getY(), pelem, elkport.getParent());
    }

    protected void applyPortLayout(double xpos, double ypos, PictogramElement pelem, ElkNode elknode) {
        int offsetx = 0;
        int offsety = 0;
        if (pelem.getGraphicsAlgorithm() != null) {
            offsetx = pelem.getGraphicsAlgorithm().getX();
            offsety = pelem.getGraphicsAlgorithm().getY();
        }
        if (pelem instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor anchor = (BoxRelativeAnchor)pelem;
            double relWidth = (xpos - (double)offsetx) / elknode.getWidth();
            if (relWidth < 0.0) {
                relWidth = 0.0;
            } else if (relWidth > 1.0) {
                relWidth = 1.0;
            }
            double relHeight = (ypos - (double)offsety) / elknode.getHeight();
            if (relHeight < 0.0) {
                relHeight = 0.0;
            } else if (relHeight > 1.0) {
                relHeight = 1.0;
            }
            anchor.setRelativeWidth(relWidth);
            anchor.setRelativeHeight(relHeight);
            this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
        } else if (pelem instanceof FixPointAnchor) {
            FixPointAnchor anchor = (FixPointAnchor)pelem;
            anchor.getLocation().setX((int)(xpos - (double)offsetx));
            anchor.getLocation().setY((int)(ypos - (double)offsety));
        }
    }

    protected void applyNodeLayout(ElkNode elknode, PictogramElement pelem) {
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        ga.setX(Math.round((float)elknode.getX()));
        ga.setY(Math.round((float)elknode.getY()));
        ga.setWidth(Math.round((float)elknode.getWidth()));
        ga.setHeight(Math.round((float)elknode.getHeight()));
        this.featureProvider.layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
    }

    protected void applyEdgeLayout(ElkEdge elkedge, PictogramElement pelem) {
        KVectorChain bendPoints = this.getBendPoints(elkedge);
        if (pelem instanceof FreeFormConnection) {
            FreeFormConnection connection = (FreeFormConnection)pelem;
            EList pointList = connection.getBendpoints();
            int i = 0;
            while (i < bendPoints.size()) {
                Point point;
                KVector kpoint = (KVector)bendPoints.get(i);
                if (i >= pointList.size()) {
                    point = Graphiti.getGaService().createPoint((int)Math.round(kpoint.x), (int)Math.round(kpoint.y));
                    pointList.add(point);
                } else {
                    point = (Point)pointList.get(i);
                    point.setX((int)Math.round(kpoint.x));
                    point.setY((int)Math.round(kpoint.y));
                }
                ++i;
            }
            while (pointList.size() > bendPoints.size()) {
                pointList.remove(pointList.size() - 1);
            }
            ElkEdgeSection edgeSection = (ElkEdgeSection)elkedge.getSections().get(0);
            if (!(elkedge.getSources().get(0) instanceof ElkPort)) {
                ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
                KVector sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
                ElkUtil.toAbsolute((KVector)sourcePoint, (ElkNode)elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)sourcePoint, (ElkNode)source);
                this.applyPortLayout(sourcePoint.x, sourcePoint.y, (PictogramElement)connection.getEnd(), source);
            }
            if (!(elkedge.getTargets().get(0) instanceof ElkPort)) {
                ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
                KVector targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
                ElkUtil.toAbsolute((KVector)targetPoint, (ElkNode)elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)targetPoint, (ElkNode)target);
                this.applyPortLayout(targetPoint.x, targetPoint.y, (PictogramElement)connection.getEnd(), target);
            }
        }
    }

    public KVectorChain getBendPoints(ElkEdge edge) {
        KVectorChain bendPoints = this.bendpointsMap.get(edge);
        if (bendPoints == null) {
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)edge.getContainingNode());
            ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
            bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            bendPoints.offset(offset);
            EdgeRouting edgeRouting = (EdgeRouting)edge.getProperty(CoreOptions.EDGE_ROUTING);
            if (edgeRouting == EdgeRouting.SPLINES && edgeSection.getBendPoints().size() >= 1) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.removeFirst();
            bendPoints.removeLast();
            this.bendpointsMap.put(edge, bendPoints);
        }
        return bendPoints;
    }

    protected void applyEdgeLabelLayout(ElkLabel elklabel, PictogramElement pelem) {
        GraphicsAlgorithm ga = pelem.getGraphicsAlgorithm();
        ConnectionDecorator decorator = (ConnectionDecorator)pelem;
        ElkEdge elkedge = (ElkEdge)elklabel.eContainer();
        KVectorChain bendPoints = new KVectorChain((Collection)this.getBendPoints(elkedge));
        KVector sourcePoint = this.layoutManager.calculateAnchorEnds((ElkConnectableShape)elkedge.getSources().get(0), null);
        bendPoints.addFirst((Object)sourcePoint);
        KVector targetPoint = this.layoutManager.calculateAnchorEnds((ElkConnectableShape)elkedge.getTargets().get(0), null);
        bendPoints.addLast((Object)targetPoint);
        KVector referencePoint = decorator.isLocationRelative() ? bendPoints.pointOnLine(decorator.getLocation() * bendPoints.totalLength()) : bendPoints.pointOnLine(decorator.getLocation());
        KVector position = new KVector(elklabel.getX(), elklabel.getY());
        ElkUtil.toAbsolute((KVector)position, (ElkNode)elkedge.getContainingNode());
        ga.setX((int)Math.round(position.x - referencePoint.x));
        ga.setY((int)Math.round(position.y - referencePoint.y));
    }
}

