/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.properties;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public class MapPropertyHolder
implements IPropertyHolder,
Serializable {
    private static final long serialVersionUID = 4507851447415709893L;
    private HashMap<IProperty<?>, Object> propertyMap;

    @Override
    public <T> MapPropertyHolder setProperty(IProperty<? super T> property, T value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        if (value == null) {
            this.propertyMap.remove(property);
        } else {
            this.propertyMap.put(property, value);
        }
        return this;
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        Object value;
        if (this.propertyMap != null && (value = this.propertyMap.get(property)) != null) {
            return (T)value;
        }
        T defaultValue = property.getDefault();
        if (defaultValue instanceof Cloneable) {
            this.setProperty(property, (Object)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public MapPropertyHolder copyProperties(IPropertyHolder other) {
        if (other == null) {
            return this;
        }
        Map<IProperty<?>, Object> otherMap = other.getAllProperties();
        if (!otherMap.isEmpty()) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap(otherMap);
            } else {
                this.propertyMap.putAll(otherMap);
            }
        }
        return this;
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        if (this.propertyMap == null) {
            return Collections.emptyMap();
        }
        return this.propertyMap;
    }
}

