/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.EdgeLabelSideSelection;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.nodespacing.LabelSide;

public final class LabelSideSelector
implements ILayoutProcessor {
    private static final LabelSide DEFAULT_LABEL_SIDE = LabelSide.BELOW;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        EdgeLabelSideSelection mode = (EdgeLabelSideSelection)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_LABEL_SIDE_SELECTION));
        monitor.begin("Label side selection (" + (Object)((Object)mode) + ")", 1.0f);
        Iterable nodes = Iterables.concat((Iterable)layeredGraph);
        switch (mode) {
            case ALWAYS_UP: {
                this.alwaysUp(nodes);
                break;
            }
            case ALWAYS_DOWN: {
                this.alwaysDown(nodes);
                break;
            }
            case DIRECTION_UP: {
                this.directionUp(nodes);
                break;
            }
            case DIRECTION_DOWN: {
                this.directionDown(nodes);
                break;
            }
            case SMART: {
                this.smart(nodes);
            }
        }
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode lNode : layer.getNodes()) {
                for (LPort port : lNode.getPorts()) {
                    for (LLabel label : port.getLabels()) {
                        if (label.getProperty(InternalProperties.LABEL_SIDE) != LabelSide.UNKNOWN) continue;
                        label.setProperty(InternalProperties.LABEL_SIDE, DEFAULT_LABEL_SIDE);
                    }
                }
                if (lNode.getType() != LNode.NodeType.LABEL || lNode.getProperty(InternalProperties.LABEL_SIDE) != LabelSide.ABOVE) continue;
                LEdge originEdge = (LEdge)((Object)lNode.getProperty(InternalProperties.ORIGIN));
                double thickness = (Double)originEdge.getProperty(LayeredOptions.EDGE_THICKNESS);
                double portPos = lNode.getSize().y - Math.ceil(thickness / 2.0);
                for (LPort port : lNode.getPorts()) {
                    port.getPosition().y = portPos;
                }
            }
        }
        monitor.done();
    }

    private void alwaysUp(Iterable<LNode> nodes) {
        for (LNode node : nodes) {
            if (node.getType() == LNode.NodeType.LABEL) {
                node.setProperty(InternalProperties.LABEL_SIDE, LabelSide.ABOVE);
            }
            for (LEdge edge : node.getOutgoingEdges()) {
                this.applyLabelSide(edge, LabelSide.ABOVE);
            }
        }
    }

    private void alwaysDown(Iterable<LNode> nodes) {
        for (LNode node : nodes) {
            if (node.getType() == LNode.NodeType.LABEL) {
                node.setProperty(InternalProperties.LABEL_SIDE, LabelSide.BELOW);
            }
            for (LEdge edge : node.getOutgoingEdges()) {
                this.applyLabelSide(edge, LabelSide.BELOW);
            }
        }
    }

    private void directionUp(Iterable<LNode> nodes) {
        for (LNode node : nodes) {
            if (node.getType() == LNode.NodeType.LABEL) {
                LabelSide side = this.doesEdgePointRight(node) ? LabelSide.ABOVE : LabelSide.BELOW;
                node.setProperty(InternalProperties.LABEL_SIDE, side);
            }
            for (LEdge edge : node.getOutgoingEdges()) {
                LabelSide side = this.doesEdgePointRight(edge) ? LabelSide.ABOVE : LabelSide.BELOW;
                this.applyLabelSide(edge, side);
            }
        }
    }

    private void directionDown(Iterable<LNode> nodes) {
        for (LNode node : nodes) {
            if (node.getType() == LNode.NodeType.LABEL) {
                LabelSide side = this.doesEdgePointRight(node) ? LabelSide.BELOW : LabelSide.ABOVE;
                node.setProperty(InternalProperties.LABEL_SIDE, side);
            }
            for (LEdge edge : node.getOutgoingEdges()) {
                LabelSide side = this.doesEdgePointRight(edge) ? LabelSide.BELOW : LabelSide.ABOVE;
                this.applyLabelSide(edge, side);
            }
        }
    }

    private void smart(Iterable<LNode> nodes) {
        HashMap nodeMarkers = Maps.newHashMap();
        for (LNode node : nodes) {
            List<LPort> eastPorts = this.getPortsBySide(node, PortSide.EAST);
            for (LPort eastPort : eastPorts) {
                for (LEdge edge : eastPort.getOutgoingEdges()) {
                    LabelSide chosenSide = LabelSide.ABOVE;
                    LNode targetNode = edge.getTarget().getNode();
                    if (targetNode.getType() == LNode.NodeType.LONG_EDGE || targetNode.getType() == LNode.NodeType.LABEL) {
                        targetNode = ((LPort)((Object)targetNode.getProperty(InternalProperties.LONG_EDGE_TARGET))).getNode();
                    }
                    if (nodeMarkers.containsKey((Object)targetNode)) {
                        chosenSide = (LabelSide)nodeMarkers.get((Object)targetNode);
                    } else {
                        chosenSide = eastPorts.size() == 2 ? (eastPort == eastPorts.get(0) ? LabelSide.ABOVE : LabelSide.BELOW) : LabelSide.ABOVE;
                        nodeMarkers.put(targetNode, chosenSide);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.setProperty(InternalProperties.LABEL_SIDE, chosenSide);
                    }
                    for (LLabel portLabel : edge.getSource().getLabels()) {
                        portLabel.setProperty(InternalProperties.LABEL_SIDE, chosenSide);
                    }
                    for (LLabel portLabel : edge.getTarget().getLabels()) {
                        portLabel.setProperty(InternalProperties.LABEL_SIDE, chosenSide);
                    }
                }
            }
        }
    }

    private List<LPort> getPortsBySide(LNode node, PortSide portSide) {
        ArrayList result = Lists.newArrayList();
        for (LPort port : node.getPorts(portSide)) {
            result.add(port);
        }
        Collections.sort(result, new Comparator<LPort>(){

            @Override
            public int compare(LPort o1, LPort o2) {
                if (o1.getPosition().y < o2.getPosition().y) {
                    return -1;
                }
                if (o1.getPosition().y == o2.getPosition().y) {
                    return 0;
                }
                return 1;
            }
        });
        return result;
    }

    private void applyLabelSide(LEdge edge, LabelSide side) {
        for (LLabel label : edge.getLabels()) {
            label.setProperty(InternalProperties.LABEL_SIDE, side);
        }
        for (LLabel portLabel : edge.getSource().getLabels()) {
            portLabel.setProperty(InternalProperties.LABEL_SIDE, side);
        }
        for (LLabel portLabel : edge.getTarget().getLabels()) {
            portLabel.setProperty(InternalProperties.LABEL_SIDE, side);
        }
    }

    private boolean doesEdgePointRight(LEdge edge) {
        return (Boolean)edge.getProperty(InternalProperties.REVERSED) == false;
    }

    private boolean doesEdgePointRight(LNode labelDummy) {
        assert (labelDummy.getType() == LNode.NodeType.LABEL);
        assert (labelDummy.getIncomingEdges().iterator().hasNext());
        assert (labelDummy.getOutgoingEdges().iterator().hasNext());
        LEdge incoming = labelDummy.getIncomingEdges().iterator().next();
        LEdge outgoing = labelDummy.getOutgoingEdges().iterator().next();
        return this.doesEdgePointRight(incoming) || this.doesEdgePointRight(outgoing);
    }
}

