/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.optimization;

import java.util.List;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.optimization.IEvaluation;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkNode;

public class CrossingMinimizationPosition
implements IEvaluation {
    private ElkNode root;

    @Override
    public double evaluate(ElkNode rootNode) {
        this.root = rootNode;
        int crossings = 0;
        List<ElkNode> nodes = RadialUtil.getSuccessors(rootNode);
        int k = 0;
        for (ElkNode node1 : nodes) {
            int i = ++k;
            while (i < nodes.size()) {
                if (this.isCrossing(node1, nodes.get(i))) {
                    ++crossings;
                }
                ++i;
            }
        }
        return crossings;
    }

    private boolean isCrossing(ElkNode node1, ElkNode node2) {
        double rootX = this.root.getX() + this.root.getWidth() / 2.0;
        double rootY = this.root.getX() + this.root.getWidth() / 2.0;
        double xPos1 = node1.getX() + node1.getWidth() / 2.0;
        double yPos1 = node1.getY() + node1.getHeight() / 2.0;
        KVector node1Vector = new KVector(xPos1, yPos1);
        KVector position1 = (KVector)node1.getProperty(CoreOptions.POSITION);
        position1.x += rootX;
        position1.y += rootY;
        double m1 = (node1Vector.y - position1.y) / (node1Vector.x - position1.x);
        double b1 = node1Vector.y - m1 * node1Vector.x;
        double xPos2 = node2.getX() + node2.getWidth() / 2.0;
        double yPos2 = node2.getY() + node2.getHeight() / 2.0;
        KVector node2Vector = new KVector(xPos2, yPos2);
        KVector position2 = (KVector)node2.getProperty(CoreOptions.POSITION);
        position2.x += rootX;
        position2.y += rootY;
        double m2 = (node2Vector.y - position2.y) / (node2Vector.x - position2.x);
        double b2 = node2Vector.y - m2 * node2Vector.x;
        double xCut = (b1 - b2) / (m2 - m1);
        if (position1.x < xCut && node1Vector.x < xCut || xCut < position1.x && xCut < node1Vector.x) {
            return false;
        }
        return !(position2.x < xCut && node2Vector.x < xCut) && (!(xCut < position2.x) || !(xCut < node2Vector.x));
    }
}

