/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKey;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyPassphrasePrompt;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Signer;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.StringUtils;

public class BouncyCastleGpgSigner
implements Signer {
    private BouncyCastleGpgKey locateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) throws CanceledException, UnsupportedCredentialItem, IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, URISyntaxException {
        if (gpgSigningKey == null || ((String)gpgSigningKey).isEmpty()) {
            gpgSigningKey = "<" + committer.getEmailAddress() + ">";
        }
        BouncyCastleGpgKeyLocator keyHelper = new BouncyCastleGpgKeyLocator((String)gpgSigningKey, passphrasePrompt);
        return keyHelper.findSecretKey();
    }

    public GpgSignature sign(Repository repository, GpgConfig config, byte[] data, PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException, IOException, UnsupportedSigningFormatException {
        String gpgSigningKey = signingKey;
        if (gpgSigningKey == null) {
            gpgSigningKey = config.getSigningKey();
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                String keyUserId;
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                PGPSecretKey secretKey = gpgKey.getSecretKey();
                if (secretKey == null) {
                    throw new JGitInternalException(BCText.get().unableToSignCommitNoSecretKey);
                }
                JcePBESecretKeyDecryptorBuilder decryptorBuilder = new JcePBESecretKeyDecryptorBuilder();
                PGPPrivateKey privateKey = null;
                if (!passphrasePrompt.hasPassphrase()) {
                    try {
                        privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(new char[0]));
                    }
                    catch (PGPException pGPException) {
                        // empty catch block
                    }
                }
                if (privateKey == null) {
                    char[] passphrase = passphrasePrompt.getPassphrase(secretKey.getPublicKey().getFingerprint(), gpgKey.getOrigin());
                    privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(passphrase));
                }
                PGPPublicKey publicKey = secretKey.getPublicKey();
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(publicKey.getAlgorithm(), 8), publicKey);
                signatureGenerator.init(0, privateKey);
                PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
                subpackets.setIssuerFingerprint(false, publicKey);
                String userId = committer.getEmailAddress();
                Iterator userIds = publicKey.getUserIDs();
                if (!(!userIds.hasNext() || StringUtils.isEmptyOrNull((String)(keyUserId = (String)userIds.next())) || userId != null && keyUserId.contains(userId))) {
                    userId = BouncyCastleGpgSigner.extractSignerId(keyUserId);
                }
                if (userId != null) {
                    subpackets.addSignerUserID(false, userId);
                }
                signatureGenerator.setHashedSubpackets(subpackets.generate());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                Object var22_27 = null;
                try (BCPGOutputStream out = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)buffer));){
                    signatureGenerator.update(data);
                    signatureGenerator.generate().encode((OutputStream)out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                return new GpgSignature(buffer.toByteArray());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public boolean canLocateSigningKey(Repository repository, GpgConfig config, PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException {
        String gpgSigningKey = signingKey;
        if (gpgSigningKey == null) {
            gpgSigningKey = config.getSigningKey();
        }
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                boolean bl = gpgKey != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    static String extractSignerId(String pgpUserId) {
        int to;
        int from = pgpUserId.indexOf(60);
        if (from >= 0 && (to = pgpUserId.indexOf(62, from + 1)) > from + 1) {
            return pgpUserId.substring(from + 1, to);
        }
        return pgpUserId;
    }
}

