/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.internal.registry;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.log.IEGFLogger;
import org.eclipse.egf.common.log.IEGFLoggerFactory;
import org.eclipse.osgi.util.NLS;

public class EGFLoggerProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _class;
    private IEGFLogger _executable;

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public IEGFLogger getEGFLogger() {
        if (this._executable == null) {
            Object object;
            block6: {
                block5: {
                    object = this._element.createExecutableExtension("class");
                    if (object != null) break block5;
                    return null;
                }
                if (object instanceof IEGFLoggerFactory) break block6;
                EGFCommonPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
                EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)IEGFLoggerFactory.class.getName()), 1);
                EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
                EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
                EGFCommonPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
                return null;
            }
            try {
                this._executable = ((IEGFLoggerFactory)object).getLogger();
            }
            catch (CoreException e) {
                EGFCommonPlugin.getDefault().logError(e);
            }
        }
        return this._executable;
    }

    public static EGFLoggerProxy createProxy(IConfigurationElement element) {
        String clazz;
        if (element == null) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((clazz = element.getAttribute("class")) == null || clazz.trim().length() == 0) {
            return null;
        }
        return new EGFLoggerProxy(element, clazz, uniqueIdentifier, handleId);
    }

    public EGFLoggerProxy(IConfigurationElement element, String clazz, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._class = clazz.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }
}

