/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.DiagnosticResourceException;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.workspace.EGFWorkspaceSynchronizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public final class EGFResourceLoadedListener
implements EGFWorkspaceSynchronizer.Delegate {
    public static final ResourceEventManager RESOURCE_MANAGER = new ResourceEventManager();
    protected IPlatformExtensionPointListener _platformListener = new IPlatformExtensionPointListener(){

        public void platformExtensionPointChanged(IPlatformExtensionPointDelta delta) {
            Resource resource;
            IPlatformFcore fcore;
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            UniqueEList deltaChangedFcores = new UniqueEList();
            HashMap<Resource, IPlatformFcore> deltaRemovedFcores = new HashMap<Resource, IPlatformFcore>();
            IPlatformFcore[] iPlatformFcoreArray = (IPlatformFcore[])delta.getRemovedPlatformExtensionPoints(IPlatformFcore.class);
            int n = iPlatformFcoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                fcore = iPlatformFcoreArray[n2];
                resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                if (resource != null) {
                    deltaRemovedFcores.put(resource, fcore);
                }
                ++n2;
            }
            iPlatformFcoreArray = (IPlatformFcore[])delta.getAddedPlatformExtensionPoints(IPlatformFcore.class);
            n = iPlatformFcoreArray.length;
            n2 = 0;
            while (n2 < n) {
                block14: {
                    IPlatformFcore deletedFcore;
                    block15: {
                        fcore = iPlatformFcoreArray[n2];
                        resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                        if (resource == null) break block14;
                        if (resource.getContents().size() != 0 || resource.getErrors().isEmpty()) break block15;
                        deletedFcore = (IPlatformFcore)deltaRemovedFcores.get(resource);
                        if (deletedFcore != null) {
                            deltaRemovedFcores.remove(resource);
                        }
                        resource.unload();
                        resource.getResourceSet().getResources().remove((Object)resource);
                        if (EGFCorePlugin.getDefault().isDebugging()) {
                            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"EGFResourceLoadedListener.platformExtensionPointChanged(...) - discard loaded empty resource with errors ''{0}''", (Object)resource.getURI()));
                        }
                        EGFResourceLoadedListener.RESOURCE_MANAGER._fcores.remove(resource);
                        resource = editingDomain.getResourceSet().getResource(fcore.getURI(), true);
                        if (resource == null) break block14;
                        if (deletedFcore != null) {
                            deltaRemovedFcores.put(resource, deletedFcore);
                        }
                    }
                    deletedFcore = (IPlatformFcore)deltaRemovedFcores.get(resource);
                    if (deltaRemovedFcores.remove(resource) != null && !deletedFcore.equals(fcore)) {
                        deltaChangedFcores.add(resource);
                    }
                    EGFResourceLoadedListener.RESOURCE_MANAGER._fcores.put(resource, fcore);
                }
                ++n2;
            }
            if (!deltaRemovedFcores.isEmpty()) {
                for (Resource resource2 : deltaRemovedFcores.keySet()) {
                    RESOURCE_MANAGER.removeResource((EditingDomain)editingDomain, resource2);
                }
            }
            if (!deltaChangedFcores.isEmpty()) {
                for (Resource resource2 : deltaChangedFcores) {
                    RESOURCE_MANAGER.reloadResource(resource2);
                }
            }
        }
    };
    private TransactionalEditingDomain _editingDomain;

    public EGFResourceLoadedListener() {
        EGFPlatformPlugin.getPlatformManager().addPlatformExtensionPointListener(this._platformListener);
    }

    public TransactionalEditingDomain getEditingDomain() {
        if (this._editingDomain == null) {
            this._editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        }
        return this._editingDomain;
    }

    public boolean handleResourcePersisted(Resource resource) {
        for (ResourceListener resourceListener : EGFResourceLoadedListener.RESOURCE_MANAGER._listeners) {
            resourceListener.internalUpdate(resource);
        }
        return true;
    }

    public boolean handleResourceMoved(Resource movedResource, URI newURI) {
        Resource resource = this.getEditingDomain().getResourceSet().getResource(movedResource.getURI(), false);
        if (resource == null) {
            resource = this.getEditingDomain().getResourceSet().getResource(newURI, false);
        }
        if (resource != null) {
            RESOURCE_MANAGER.movedResource(this.getEditingDomain(), resource, newURI);
        }
        return true;
    }

    public boolean handleResourceDeleted(Resource deletedResource) {
        IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore(deletedResource);
        if (fcore == null) {
            RESOURCE_MANAGER.removeResource((EditingDomain)this.getEditingDomain(), deletedResource);
        }
        return true;
    }

    public boolean handleResourceChanged(Resource changedResource) {
        List<ResourceUser> users = EGFResourceLoadedListener.RESOURCE_MANAGER._observers.get(changedResource);
        if (users == null) {
            RESOURCE_MANAGER.reloadResource(changedResource);
            return true;
        }
        boolean hasSavedResource = false;
        boolean isDirty = false;
        for (ResourceUser user : users) {
            hasSavedResource |= user.userHasSavedResource();
            isDirty |= user.isDirty();
        }
        if (!hasSavedResource && !isDirty) {
            RESOURCE_MANAGER.reloadResource(changedResource);
            return true;
        }
        if (!hasSavedResource && isDirty) {
            for (ResourceListener resourceListener : EGFResourceLoadedListener.RESOURCE_MANAGER._listeners) {
                resourceListener.externalUpdate(changedResource);
            }
            return true;
        }
        for (ResourceListener resourceListener : EGFResourceLoadedListener.RESOURCE_MANAGER._listeners) {
            resourceListener.internalUpdate(changedResource);
        }
        return true;
    }

    public void dispose() {
        EGFPlatformPlugin.getPlatformManager().removePlatformExtensionPointListener(this._platformListener);
    }

    public static class ResourceEventManager {
        final List<ResourceListener> _listeners = new ArrayList<ResourceListener>();
        final Map<Resource, List<ResourceUser>> _observers = new HashMap<Resource, List<ResourceUser>>();
        final Map<Resource, IPlatformFcore> _fcores = new HashMap<Resource, IPlatformFcore>();

        public void addObserver(ResourceUser resourceUser) {
            Resource resource = resourceUser.getResource();
            List<ResourceUser> list = this._observers.get(resource);
            if (list == null) {
                list = new ArrayList<ResourceUser>();
                this._observers.put(resource, list);
                IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore(resource);
                if (fcore != null) {
                    this._fcores.put(resource, fcore);
                }
            }
            list.add(resourceUser);
            this._listeners.add(resourceUser.getListener());
        }

        public void removeObserver(ResourceUser resourceUser) {
            Resource resource = resourceUser.getResource();
            List<ResourceUser> list = this._observers.get(resource);
            if (list == null) {
                return;
            }
            list.remove(resourceUser);
            if (list.isEmpty()) {
                try {
                    resource.unload();
                    this._observers.remove(resource);
                    this._fcores.remove(resource);
                    if (!this.noMoreObserver()) {
                        resource.load(Collections.EMPTY_MAP);
                    }
                }
                catch (IOException ioe) {
                    resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
                }
            }
            this._listeners.remove(resourceUser.getListener());
            if (this.noMoreObserver()) {
                this.clearResourceSet();
            }
        }

        private void clearResourceSet() {
            final TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            try {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        Iterator it = editingDomain.getResourceSet().getResources().iterator();
                        while (it.hasNext()) {
                            Resource resource = (Resource)it.next();
                            resource.unload();
                            it.remove();
                        }
                    }
                });
                if (EGFCorePlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo("EGFResourceLoadedListener.clearResourceSet()");
                }
            }
            catch (InterruptedException e) {
                EGFCorePlugin.getDefault().logError(e);
            }
            this._fcores.clear();
        }

        private boolean noMoreObserver() {
            for (List<ResourceUser> users : this._observers.values()) {
                if (users.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public void removeResource(EditingDomain editingDomain, Resource resource) {
            Iterator<ResourceUser> iterator;
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            boolean isDirty = false;
            List<ResourceUser> users = this._observers.get(resource);
            if (users != null && (iterator = users.iterator()).hasNext()) {
                ResourceUser user = iterator.next();
                isDirty = user.isDirty();
            }
            for (ResourceListener resourceListener : this._listeners) {
                resourceListener.resourceDeleted(resource);
            }
            if (!isDirty) {
                resource.unload();
                this._fcores.remove(resource);
            }
        }

        public void reloadResource(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            try {
                resource.unload();
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException ioe) {
                resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
            }
            for (ResourceListener resourceListener : this._listeners) {
                resourceListener.resourceReloaded(resource);
            }
        }

        public void movedResource(TransactionalEditingDomain editingDomain, Resource movedResource, URI newURI) {
            if (movedResource == null) {
                throw new IllegalArgumentException();
            }
            URI oldURI = movedResource.getURI();
            Resource resource = movedResource.getResourceSet().getResource(newURI, false);
            if (resource != null && resource.getContents().size() == 0 && !resource.getErrors().isEmpty()) {
                resource.unload();
                resource.getResourceSet().getResources().remove((Object)resource);
                if (EGFCorePlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"EGFResourceLoadedListener.movedResource(...) - discard loaded empty resource with errors ''{0}''", (Object)resource.getURI()));
                }
                this._fcores.remove(resource);
                movedResource = editingDomain.getResourceSet().getResource(newURI, true);
            }
            this._fcores.remove(movedResource);
            movedResource.setURI(newURI);
            for (ResourceListener resourceListener : this._listeners) {
                resourceListener.resourceMoved(movedResource, oldURI);
            }
        }

        public boolean resourceHasBeenExternallyChanged(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            List<ResourceUser> users = this._observers.get(resource);
            if (users == null) {
                return false;
            }
            boolean resourceHasBeenExternallyChanged = false;
            Iterator<ResourceUser> iterator = users.iterator();
            if (iterator.hasNext()) {
                ResourceUser user = iterator.next();
                resourceHasBeenExternallyChanged = user.resourceHasBeenExternallyChanged();
            }
            return resourceHasBeenExternallyChanged;
        }

        public void populateUndoContext(IOperationHistory operationHistory, ObjectUndoContext undoContext, Resource resource) {
            if (resource == null || undoContext == null) {
                throw new IllegalArgumentException();
            }
            List<ResourceUser> users = this._observers.get(resource);
            if (users == null) {
                return;
            }
            ObjectUndoContext innerUndoContext = null;
            for (ResourceUser user : users) {
                if (user.getUndoContext() == undoContext) continue;
                innerUndoContext = user.getUndoContext();
                break;
            }
            if (innerUndoContext != null) {
                IUndoableOperation operation;
                IUndoableOperation[] iUndoableOperationArray = operationHistory.getUndoHistory(innerUndoContext);
                int n = iUndoableOperationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    operation = iUndoableOperationArray[n2];
                    operation.addContext((IUndoContext)undoContext);
                    ++n2;
                }
                iUndoableOperationArray = operationHistory.getRedoHistory((IUndoContext)innerUndoContext);
                n = iUndoableOperationArray.length;
                n2 = 0;
                while (n2 < n) {
                    operation = iUndoableOperationArray[n2];
                    operation.addContext((IUndoContext)undoContext);
                    ++n2;
                }
            }
        }
    }

    public static interface ResourceListener {
        public void resourceDeleted(Resource var1);

        public void resourceMoved(Resource var1, URI var2);

        public void resourceReloaded(Resource var1);

        public void externalUpdate(Resource var1);

        public void internalUpdate(Resource var1);
    }

    public static interface ResourceUser {
        public Resource getResource();

        public ResourceListener getListener();

        public boolean isDirty();

        public boolean userHasSavedResource();

        public boolean resourceHasBeenExternallyChanged();

        public IOperationHistory getOperationHistory();

        public ObjectUndoContext getUndoContext();
    }
}

