/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.helper;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponentContract;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.egf.model.types.Type;
import org.eclipse.emf.common.util.UniqueEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContractHelper {
    private InvocationContractHelper() {
    }

    public static Collection<Contract> getAvailableFactoryComponentContract(InvocationContract invocationContract) {
        UniqueEList result = new UniqueEList();
        if (invocationContract.getFactoryComponent() == null || invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null) {
            return result;
        }
        if (invocationContract.getOrchestrationParameter() != null && invocationContract.getInvokedMode() == ContractMode.IN) {
            return result;
        }
        if (invocationContract.getInvokedMode() == ContractMode.IN) {
            result.addAll(invocationContract.getFactoryComponent().getContracts(invocationContract.getInvokedContract().getType(), ContractMode.IN));
        } else {
            for (Contract contract : invocationContract.getFactoryComponent().getContracts(invocationContract.getInvokedContract().getType(), invocationContract.getInvokedMode())) {
                if (((FactoryComponentContract)contract).getInvocationContracts().size() != 0) continue;
                result.add(contract);
            }
        }
        if ((invocationContract.getOrchestrationParameter() != null || invocationContract.getSourceInvocationContract() != null) && invocationContract.getInvokedMode() == ContractMode.IN_OUT) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Contract contract = (Contract)it.next();
                if (contract == null || contract.getMode() == ContractMode.OUT) continue;
                it.remove();
            }
        }
        return result;
    }

    public static Collection<OrchestrationParameter> getAvailableOrchestrationParameter(InvocationContract invocationContract) {
        UniqueEList result = new UniqueEList();
        if (invocationContract.getFactoryComponent() == null || invocationContract.getFactoryComponent().getOrchestration() == null || invocationContract.getInvokedContract() == null || invocationContract.getInvokedContract().getType() == null) {
            return result;
        }
        if (invocationContract.getInvokedMode() == ContractMode.OUT) {
            return result;
        }
        if (invocationContract.getFactoryComponentContract() != null && invocationContract.getInvokedMode() != ContractMode.IN_OUT) {
            return result;
        }
        if (invocationContract.getSourceInvocationContract() != null) {
            return result;
        }
        result.addAll(invocationContract.getFactoryComponent().getOrchestration().getOrchestrationParameters(invocationContract.getInvokedContract().getType()));
        return result;
    }

    public static Collection<Contract> getAvailableInvokedContract(InvocationContract invocationContract) {
        UniqueEList result;
        block9: {
            block8: {
                result = new UniqueEList();
                if (invocationContract.getInvocation() == null || invocationContract.getInvocation().getInvokedActivity() == null) {
                    return result;
                }
                if (invocationContract.getType() == null) break block8;
                if (invocationContract.getFactoryComponentContract() != null) {
                    result.addAll(invocationContract.getInvocation().getInvokedActivity().getContracts(invocationContract.getType(), invocationContract.getFactoryComponentContract().getMode()));
                } else {
                    result.addAll(invocationContract.getInvocation().getInvokedActivity().getContracts(invocationContract.getType()));
                }
                if (result.size() <= 0) break block9;
                for (Contract innerContract : invocationContract.getInvocation().getInvokedContracts(invocationContract.getType())) {
                    result.remove(innerContract);
                }
                break block9;
            }
            if (invocationContract.getFactoryComponentContract() != null) {
                result.addAll(invocationContract.getInvocation().getInvokedActivity().getContracts(invocationContract.getFactoryComponentContract().getMode()));
            } else {
                result.addAll(invocationContract.getInvocation().getInvokedActivity().getContracts());
            }
            if (result.size() > 0) {
                for (Contract innerContract : invocationContract.getInvocation().getInvokedContracts()) {
                    result.remove(innerContract);
                }
            }
        }
        return result;
    }

    public static Collection<InvocationContract> getAvailableSourceInvocationContract(InvocationContract invocationContract) {
        UniqueEList result = new UniqueEList();
        if (invocationContract.getInvocation() == null || invocationContract.getFactoryComponent() == null || invocationContract.getFactoryComponent().getOrchestration() == null) {
            return result;
        }
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvokedMode() == ContractMode.OUT || invocationContract.getInvokedContract().getType() == null) {
            return result;
        }
        Type type = invocationContract.getType();
        if (type == null) {
            type = invocationContract.getInvokedContract().getType();
        }
        if (invocationContract.getOrchestrationParameter() != null) {
            return result;
        }
        if (invocationContract.getFactoryComponentContract() != null && invocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT) {
            return result;
        }
        for (Invocation invocation : invocationContract.getFactoryComponent().getOrchestration().getInvocations()) {
            if (invocation == invocationContract.getInvocation()) break;
            for (InvocationContract innerInvocationContract : invocation.getInvocationContracts()) {
                if (innerInvocationContract.getInvokedContract() == null || innerInvocationContract.getInvokedContract().getType() == null || innerInvocationContract.getInvokedMode() != ContractMode.IN_OUT && innerInvocationContract.getInvokedMode() != ContractMode.OUT || innerInvocationContract.getSourceInvocationContract() != null) continue;
                Type innerType = innerInvocationContract.getType();
                if (innerType == null) {
                    innerType = innerInvocationContract.getInvokedContract().getType();
                }
                if (!ClassHelper.asSubClass((Class)type.getType(), (Class)innerType.getType())) continue;
                result.add(innerInvocationContract);
            }
        }
        return result;
    }

    public static Collection<InvocationContract> getAvailableTargetInvocationContract(InvocationContract invocationContract) {
        UniqueEList result = new UniqueEList();
        if (invocationContract.getInvocation() == null || invocationContract.getFactoryComponent() == null || invocationContract.getFactoryComponent().getOrchestration() == null) {
            return result;
        }
        if (invocationContract.getInvokedContract() == null || invocationContract.getInvokedMode() == ContractMode.IN || invocationContract.getInvokedContract().getType() == null) {
            return result;
        }
        Type type = invocationContract.getType();
        if (type == null) {
            type = invocationContract.getInvokedContract().getType();
        }
        boolean analyse = false;
        for (Invocation invocation : invocationContract.getFactoryComponent().getOrchestration().getInvocations()) {
            if (invocation == invocationContract.getInvocation()) {
                analyse = true;
                continue;
            }
            if (!analyse) continue;
            for (InvocationContract innerInvocationContract : invocation.getInvocationContracts()) {
                if (innerInvocationContract.getInvokedContract() == null || innerInvocationContract.getInvokedContract().getType() == null || innerInvocationContract.getOrchestrationParameter() != null || innerInvocationContract.getFactoryComponentContract() != null && innerInvocationContract.getFactoryComponentContract().getMode() != ContractMode.OUT || innerInvocationContract.getInvokedMode() != ContractMode.IN_OUT && innerInvocationContract.getInvokedMode() != ContractMode.IN || innerInvocationContract.getSourceInvocationContract() != null) continue;
                Type innerType = innerInvocationContract.getType();
                if (innerType == null) {
                    innerType = innerInvocationContract.getInvokedContract().getType();
                }
                if (!ClassHelper.asSubClass((Class)type.getType(), (Class)innerType.getType())) continue;
                result.add(innerInvocationContract);
            }
        }
        return result;
    }
}

