/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.model.EGFModelsPlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.ActivityContractContainer;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FactoryComponentContract;
import org.eclipse.egf.model.fcore.FactoryComponentContractContainer;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContext;
import org.eclipse.egf.model.fcore.InvocationContextConnector;
import org.eclipse.egf.model.fcore.InvocationContextContainer;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationContext;
import org.eclipse.egf.model.fcore.OrchestrationContextContainer;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.helper.ActivityCycleFinder;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreValidator
extends EObjectValidator {
    public static final FcoreValidator INSTANCE = new FcoreValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.fcore";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public FcoreValidator() {
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return FcorePackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateModelElement((ModelElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateActivity((Activity)value, diagnostics, context);
            }
            case 2: {
                return this.validateActivityContract((ActivityContract)value, diagnostics, context);
            }
            case 3: {
                return this.validateActivityContractContainer((ActivityContractContainer)value, diagnostics, context);
            }
            case 4: {
                return this.validateFactoryComponent((FactoryComponent)value, diagnostics, context);
            }
            case 5: {
                return this.validateFactoryComponentContract((FactoryComponentContract)value, diagnostics, context);
            }
            case 6: {
                return this.validateFactoryComponentContractContainer((FactoryComponentContractContainer)value, diagnostics, context);
            }
            case 7: {
                return this.validateViewpointContainer((ViewpointContainer)value, diagnostics, context);
            }
            case 8: {
                return this.validateViewpoint((Viewpoint)value, diagnostics, context);
            }
            case 9: {
                return this.validateOrchestration((Orchestration)value, diagnostics, context);
            }
            case 10: {
                return this.validateOrchestrationContext((OrchestrationContext)value, diagnostics, context);
            }
            case 11: {
                return this.validateOrchestrationContextContainer((OrchestrationContextContainer)value, diagnostics, context);
            }
            case 12: {
                return this.validateInvocation((Invocation)value, diagnostics, context);
            }
            case 13: {
                return this.validateInvocationContext((InvocationContext)value, diagnostics, context);
            }
            case 14: {
                return this.validateInvocationContextConnector((InvocationContextConnector)value, diagnostics, context);
            }
            case 15: {
                return this.validateInvocationContextContainer((InvocationContextContainer)value, diagnostics, context);
            }
            case 16: {
                return this.validateContractMode((ContractMode)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelElement, diagnostics, context);
    }

    public boolean validateActivity(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(activity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(activity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_ActivityCycle(activity, diagnostics, context);
        }
        return result;
    }

    public boolean validateActivity_ActivityCycle(Activity activity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ActivityCycleFinder finder = new ActivityCycleFinder(activity);
        ModelElement element = finder.getFirstRepetition();
        if (element != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Activity Cycle", FcoreValidator.getObjectLabel((EObject)element, context)}, new Object[]{element}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateActivityContract(ActivityContract activityContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(activityContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivityContract_MandatoryName(activityContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivityContract_UniqueName(activityContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateActivityContractContainer(ActivityContractContainer activityContractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(activityContractContainer, diagnostics, context);
    }

    public boolean validateFactoryComponent(FactoryComponent factoryComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivity_ActivityCycle(factoryComponent, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactoryComponentContract(FactoryComponentContract factoryComponentContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(factoryComponentContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivityContract_MandatoryName(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateActivityContract_UniqueName(factoryComponentContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFactoryComponentContract_OutModeIsRestricted(factoryComponentContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateFactoryComponentContractContainer(FactoryComponentContractContainer factoryComponentContractContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(factoryComponentContractContainer, diagnostics, context);
    }

    public boolean validateViewpointContainer(ViewpointContainer viewpointContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewpointContainer, diagnostics, context);
    }

    public boolean validateViewpoint(Viewpoint viewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewpoint, diagnostics, context);
    }

    public boolean validateOrchestration(Orchestration orchestration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(orchestration, diagnostics, context);
    }

    public boolean validateOrchestrationContext(OrchestrationContext orchestrationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(orchestrationContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(orchestrationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOrchestrationContext_UselessOrchestrationContext(orchestrationContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateOrchestrationContext_UselessOrchestrationContext(OrchestrationContext orchestrationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (orchestrationContext.getInvocationContexts() == null || orchestrationContext.getInvocationContexts().size() < 2) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Useless OrchestrationContext. This OrchestrationContext could be directly defined in an InvocationContext.", FcoreValidator.getObjectLabel((EObject)orchestrationContext, context)}, new Object[]{orchestrationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateOrchestrationContextContainer(OrchestrationContextContainer orchestrationContextContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(orchestrationContextContainer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(orchestrationContextContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOrchestrationContextContainer_UselessOrchestrationContextContainer(orchestrationContextContainer, diagnostics, context);
        }
        return result;
    }

    public boolean validateOrchestrationContextContainer_UselessOrchestrationContextContainer(OrchestrationContextContainer orchestrationContextContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (orchestrationContextContainer.getOrchestrationContexts() == null || orchestrationContextContainer.getOrchestrationContexts().size() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Useless OrchestrationContextContainer. It should contain at least one InvocationContext to be useful.", FcoreValidator.getObjectLabel((EObject)orchestrationContextContainer, context)}, new Object[]{orchestrationContextContainer}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocation(Invocation<?> invocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invocation, diagnostics, context);
    }

    public boolean validateInvocationContext(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(invocationContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_ValidActivityContract(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_ValidActivityContractType(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_ValidContext(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_ValidExposedContract(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_ValidExposedContractType(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_MandatoryTypeValue(invocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInvocationContext_UselessType(invocationContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateInvocationContext_ValidActivityContract(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getActivityContract() == null || invocationContext.getInvocation() == null || invocationContext.getInvocation().getActivity() == null) {
            return true;
        }
        boolean found = false;
        for (ActivityContract activityContract : ((Activity)invocationContext.getInvocation().getActivity()).getActivityContracts()) {
            if (activityContract != invocationContext.getActivityContract()) continue;
            found = true;
            break;
        }
        if (!found) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ValidActivityContract", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContext_ValidActivityContractType(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getActivityContract() == null || invocationContext.getActivityContract().getType() == null || invocationContext.getType() == null) {
            return true;
        }
        if (!ClassHelper.asSubClass(invocationContext.getActivityContract().getType().getType(), invocationContext.getType().getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"InvocationContext Type and ActivityContract Type mismatch.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContext_ValidContext(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean mistmatch = false;
        if (invocationContext.getOrchestrationContext() != null && invocationContext.getFactoryComponentExposedContract() != null) {
            if (invocationContext.getMode() == ContractMode.OUT) {
                mistmatch = true;
            } else if (invocationContext.getFactoryComponentExposedContract().getMode() != ContractMode.OUT) {
                mistmatch = true;
            }
        }
        if (mistmatch) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"InvocationContext should exist in OrchestrationContext or FactoryComponentExposedContract but not both.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContextConnector(InvocationContextConnector invocationContextConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invocationContextConnector, diagnostics, context);
    }

    public boolean validateInvocationContextContainer(InvocationContextContainer invocationContextContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invocationContextContainer, diagnostics, context);
    }

    public boolean validateInvocationContext_ValidExposedContract(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getFactoryComponentExposedContract() == null || invocationContext.getActivityContract() == null) {
            return true;
        }
        boolean mistmatch = false;
        if (invocationContext.getFactoryComponentExposedContract().getMode() == ContractMode.IN && invocationContext.getActivityContract().getMode() == ContractMode.OUT) {
            mistmatch = true;
        } else if (invocationContext.getFactoryComponentExposedContract().getMode() == ContractMode.OUT && invocationContext.getActivityContract().getMode() == ContractMode.IN) {
            mistmatch = true;
        }
        if (mistmatch) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"FactoryComponentExposedContract and ActivityContract Mode mismatch.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContext_ValidExposedContractType(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getFactoryComponentExposedContract() == null || invocationContext.getFactoryComponentExposedContract().getType() == null || invocationContext.getActivityContract() == null || invocationContext.getActivityContract().getType() == null) {
            return true;
        }
        if (!ClassHelper.asSubClass(invocationContext.getFactoryComponentExposedContract().getType().getType(), invocationContext.getActivityContract().getType().getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ExposedContract Type is not a subtype of ActivityContract Type.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContext_MandatoryTypeValue(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) {
            return true;
        }
        if (invocationContext.getType() == null || invocationContext.getType().getValue() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Useless InvocationContext, a Type and a Value are needed to be useful.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateInvocationContext_UselessType(InvocationContext invocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (invocationContext.getOrchestrationContext() == null && invocationContext.getFactoryComponentExposedContract() == null) {
            return true;
        }
        boolean valid = true;
        if (invocationContext.getMode() == ContractMode.IN_OUT) {
            if (invocationContext.getOrchestrationContext() != null && invocationContext.getFactoryComponentExposedContract() != null && invocationContext.getType() != null) {
                valid = false;
            }
        } else if (invocationContext.getType() != null) {
            valid = false;
        }
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Useless Type. InvocationContext is used in an OrchestrationContext or an ExposedContract.", FcoreValidator.getObjectLabel((EObject)invocationContext, context)}, new Object[]{invocationContext}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateActivityContract_MandatoryName(ActivityContract activityContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (activityContract.getName() == null || activityContract.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ActivityContract Name is mandatory.", FcoreValidator.getObjectLabel((EObject)activityContract, context)}, new Object[]{activityContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateActivityContract_UniqueName(ActivityContract activityContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (activityContract.getName() == null) {
            return true;
        }
        boolean collapse = false;
        for (ActivityContract innerActivityContract : activityContract.getActivityContracts()) {
            if (innerActivityContract == activityContract || activityContract.getMode() == ContractMode.IN && innerActivityContract.getMode() == ContractMode.OUT || activityContract.getMode() == ContractMode.OUT && innerActivityContract.getMode() == ContractMode.IN || !activityContract.getName().equals(innerActivityContract.getName())) continue;
            collapse = true;
            break;
        }
        if (collapse) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ActivityContract Name should be unique in its ActivityContractContainer.", FcoreValidator.getObjectLabel((EObject)activityContract, context)}, new Object[]{activityContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateFactoryComponentContract_OutModeIsRestricted(FactoryComponentContract factoryComponentContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (factoryComponentContract.getMode() == ContractMode.IN || factoryComponentContract.getInvocationContexts() == null) {
            return true;
        }
        if (factoryComponentContract.getInvocationContexts().size() > 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Out or In_Out Contract Mode should have only one assigned InvocationContext.", FcoreValidator.getObjectLabel((EObject)factoryComponentContract, context)}, new Object[]{factoryComponentContract}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateContractMode(ContractMode contractMode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelsPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

