/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFValidator;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.internal.dialogs.ActivityValidationSelectionDialog;
import org.eclipse.egf.producer.ui.internal.ui.ProducerUIImages;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunActivityAction
implements IObjectActionDelegate {
    private Activity _activity;
    private List<Activity> _validates = null;

    public void run(IAction action) {
        this._validates = null;
        if (this._activity == null) {
            return;
        }
        final IActivityManager[] activityManager = new IActivityManager[1];
        final Throwable[] throwable = new Throwable[1];
        final Diagnostic[] invokeDiag = new Diagnostic[1];
        final int[] ticks = new int[1];
        try {
            ActivityManagerProducer producer = null;
            try {
                producer = EGFProducerPlugin.getActivityManagerProducer((Activity)this._activity);
            }
            catch (MissingExtensionException mee) {
                throw new InvocationException((Throwable)mee);
            }
            activityManager[0] = producer.createActivityManager(this._activity);
        }
        catch (Throwable t) {
            throwable[0] = t;
        }
        if (throwable[0] == null) {
            try {
                EGFValidator validator;
                Diagnostic validationDiag;
                IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
                String validate = store.getString("org.eclipse.egf.core.validate.model.instances.before.launch");
                List activities = activityManager[0].getActivities();
                int status = this.showValidateDialog(activities, !validate.equals("never"), validate.equals("prompt"));
                if (status != 0) {
                    return;
                }
                if (this._validates != null && this._validates.size() != 0 && (validationDiag = (validator = new EGFValidator((Collection)activities)).validate()).getSeverity() != 0) {
                    return;
                }
            }
            catch (InvocationException ie) {
                throwable[0] = ie;
            }
        }
        if (throwable[0] == null) {
            try {
                activityManager[0].initializeContext();
                final Diagnostic preInvokeDiag = activityManager[0].canInvoke();
                if (preInvokeDiag.getSeverity() != 0) {
                    if (EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                        EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EGFValidator.handleDiagnostic((String)ProducerUIMessages._UI_CantInvokeProblems_title, (String)ProducerUIMessages._UI_CantInvokeProblems_message, (Diagnostic)preInvokeDiag);
                            }
                        });
                    }
                    if (preInvokeDiag.getSeverity() == 4) {
                        return;
                    }
                }
            }
            catch (InvocationException ie) {
                throwable[0] = ie;
            }
        }
        if (throwable[0] == null) {
            try {
                ticks[0] = activityManager[0].getSteps();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
        }
        if (throwable[0] == null) {
            WorkspaceJob activityJob = new WorkspaceJob(ProducerUIMessages.GlobalRunActivityAction_label){

                public boolean belongsTo(Object family) {
                    return EGFCorePlugin.FAMILY_MANUAL_BUILD.equals(family);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)activityManager[0].getName()), (int)(1000 * ticks[0]));
                    try {
                        try {
                            try {
                                if (EGFProducerUIPlugin.getDefault().isDebugging()) {
                                    EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)"Activity ''{0}'' will invoke ''{1}'' step(s).", (Object)EMFHelper.getText((Object)RunActivityAction.this._activity), (Object)ticks[0]));
                                }
                                invokeDiag[0] = activityManager[0].invoke((IProgressMonitor)subMonitor.newChild(1000 * ticks[0], 0));
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                throwable[0] = ie;
                                try {
                                    activityManager[0].dispose();
                                }
                                catch (InvocationException ie2) {
                                    if (ie2.getCause() != null && ie2.getCause() instanceof CoreException) {
                                        throw (CoreException)ie2.getCause();
                                    }
                                    throwable[0] = ie2;
                                }
                                catch (Throwable t) {
                                    throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                                }
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                        finally {
                            try {
                                activityManager[0].dispose();
                            }
                            catch (InvocationException ie) {
                                if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                                    throw (CoreException)ie.getCause();
                                }
                                throwable[0] = ie;
                            }
                            catch (Throwable t) {
                                throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                            }
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            activityJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            activityJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ProducerUIImages.EGF_RUN_ACTIVITY);
            activityJob.setUser(true);
            activityJob.schedule();
            try {
                activityJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (throwable[0] != null && !(throwable[0] instanceof InterruptedException)) {
            ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)throwable[0]);
        } else if (invokeDiag[0] != null && invokeDiag[0].getSeverity() != 0 && EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
            EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                public void run() {
                    EGFValidator.handleDiagnostic((String)ProducerUIMessages._UI_CantInvokeProblems_title, (String)ProducerUIMessages._UI_CantInvokeProblems_message, (Diagnostic)invokeDiag[0]);
                }
            });
        }
    }

    protected Activity getSelection(IStructuredSelection selection) {
        Object adaptedObject;
        Object adaptedObject2;
        Object selectedObject = selection.getFirstElement();
        if (selectedObject == null) {
            return null;
        }
        if (selectedObject instanceof Activity) {
            return (Activity)selectedObject;
        }
        if (selectedObject instanceof IAdaptable && (adaptedObject2 = ((IAdaptable)selectedObject).getAdapter(Activity.class)) != null && adaptedObject2 instanceof Activity) {
            return (Activity)adaptedObject2;
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        if (adapterManager.hasAdapter(selectedObject, Activity.class.getName()) && (adaptedObject = adapterManager.loadAdapter(selectedObject, IFile.class.getName())) instanceof Activity) {
            return (Activity)adaptedObject;
        }
        return null;
    }

    private int showValidateDialog(List<Activity> activities, boolean validate, boolean prompt) {
        if (validate) {
            if (prompt && activities != null && activities.size() > 0) {
                ActivityValidationSelectionDialog dialog = new ActivityValidationSelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), activities);
                if (dialog.open() == 1) {
                    return 1;
                }
                Object[] objects = dialog.getResult();
                this._validates = new ArrayList<Activity>(objects.length);
                int i = 0;
                while (i < objects.length) {
                    this._validates.add((Activity)objects[i]);
                    ++i;
                }
            } else {
                this._validates = activities;
            }
        }
        return 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._activity = null;
        if (selection instanceof IStructuredSelection) {
            this._activity = this.getSelection((IStructuredSelection)selection);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart activePart) {
    }
}

