/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import java.util.Collection;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.producer.l10n.CoreProducerMessages;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.ActivityContract;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContext;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.producer.context.IInvocationProductionContext;
import org.eclipse.egf.producer.context.IOrchestrationProductionContext;
import org.eclipse.egf.producer.internal.context.ModelElementProductionContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationProductionContext
extends ModelElementProductionContext<InvocationContext>
implements IInvocationProductionContext {
    public InvocationProductionContext(Invocation<?> element, ProjectBundleSession projectBundleSession) {
        super((ModelElement)element, projectBundleSession);
    }

    public InvocationProductionContext(IOrchestrationProductionContext parent, Invocation<?> element, ProjectBundleSession projectBundleSession) {
        super(parent, (ModelElement)element, projectBundleSession);
    }

    @Override
    public Invocation<?> getElement() {
        return (Invocation)super.getElement();
    }

    @Override
    public IOrchestrationProductionContext getParent() {
        return (IOrchestrationProductionContext)super.getParent();
    }

    public Class<?> getInputValueType(Object key) throws InvocationException {
        ProductionContext.Data data;
        InvocationContext invocationContext = this.getInvocationContext(key, (Collection<InvocationContext>)this.getElement().getInvocationContexts(ContractMode.IN));
        if (invocationContext == null) {
            return null;
        }
        Class valueType = null;
        if ((invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) && this.getParent() != null) {
            valueType = this.getParent().getInputValueType(invocationContext);
        }
        if (valueType == null && (data = (ProductionContext.Data)this._inputDatas.get(invocationContext)) != null) {
            valueType = data.getType();
        }
        return valueType;
    }

    public <R> R getInputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data data;
        InvocationContext invocationContext = this.getInvocationContext(key, (Collection<InvocationContext>)this.getElement().getInvocationContexts(ContractMode.IN));
        if (invocationContext == null) {
            return null;
        }
        Object value = null;
        if ((invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) && this.getParent() != null) {
            value = this.getParent().getInputValue(invocationContext, clazz);
        }
        if (value == null && (data = (ProductionContext.Data)this._inputDatas.get(invocationContext)) != null) {
            value = this.getValue(invocationContext, clazz, data);
        }
        return (R)value;
    }

    public Class<?> getOutputValueType(Object key) throws InvocationException {
        ProductionContext.Data data;
        InvocationContext invocationContext = this.getInvocationContext(key, (Collection<InvocationContext>)this.getElement().getInvocationContexts(ContractMode.OUT));
        if (invocationContext == null) {
            return null;
        }
        Class valueType = null;
        if ((invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) && this.getParent() != null) {
            valueType = this.getParent().getOutputValueType(invocationContext);
        }
        if (valueType == null && (data = (ProductionContext.Data)this._outputDatas.get(invocationContext)) != null) {
            valueType = data.getType();
        }
        return valueType;
    }

    public <R> R getOutputValue(Object key, Class<R> clazz) throws InvocationException {
        ProductionContext.Data data;
        InvocationContext invocationContext = this.getInvocationContext(key, (Collection<InvocationContext>)this.getElement().getInvocationContexts(ContractMode.OUT));
        if (invocationContext == null) {
            return null;
        }
        Object value = null;
        if ((invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) && this.getParent() != null) {
            value = this.getParent().getOutputValue(invocationContext, clazz);
        }
        if (value == null && (data = (ProductionContext.Data)this._outputDatas.get(invocationContext)) != null) {
            value = this.getValue(invocationContext, clazz, data);
        }
        return (R)value;
    }

    public void setOutputValue(Object key, Object value) throws InvocationException {
        ProductionContext.Data data;
        InvocationContext invocationContext = this.getInvocationContext(key, (Collection<InvocationContext>)this.getElement().getInvocationContexts(ContractMode.OUT));
        if (invocationContext == null) {
            return;
        }
        if ((invocationContext.getOrchestrationContext() != null || invocationContext.getFactoryComponentExposedContract() != null) && this.getParent() != null) {
            this.getParent().setOutputValue(invocationContext, value);
        }
        if ((data = (ProductionContext.Data)this._outputDatas.get(invocationContext)) == null) {
            return;
        }
        if (!(value == null || ClassHelper.asSubClass(value.getClass(), (Class)data.getType()) && data.getType().isInstance(value))) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{data.getType().getName(), EMFHelper.getText((Object)key), value.getClass().getName(), this.getName()}));
        }
        data.setValue(value);
    }

    private InvocationContext getInvocationContext(Object key, Collection<InvocationContext> keys) throws InvocationException {
        if (key == null) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_null_key, (Object)this.getName()));
        }
        if (!(key instanceof ActivityContract)) {
            throw new InvocationException(NLS.bind((String)CoreProducerMessages.ProductionContext_wrong_type, (Object[])new Object[]{ActivityContract.class.getName(), EMFHelper.getText((Object)key), key.getClass().getName(), this.getName()}));
        }
        InvocationContext invocationContext = null;
        for (InvocationContext innerInvocationContext : keys) {
            if (key != innerInvocationContext.getActivityContract()) continue;
            invocationContext = innerInvocationContext;
            break;
        }
        return invocationContext;
    }
}

