/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class VariablesEditDialog
extends SelectionStatusDialog {
    private Text nameText;
    private Text typeText;
    private String name;
    private String typeName;
    private String type;
    private TransactionalEditingDomain editingDomain;

    public VariablesEditDialog(Shell shell, Object selectItem, TransactionalEditingDomain editingDomain) {
        super(shell);
        this.editingDomain = editingDomain;
        this.setDefaultValue(selectItem);
    }

    private void setDefaultValue(Object selectItem) {
        if (selectItem instanceof PatternVariable) {
            PatternVariable PatternVariable2 = (PatternVariable)selectItem;
            this.type = PatternVariable2.getType();
            this.setValue((ModelElement)PatternVariable2);
        } else if (selectItem instanceof PatternParameter) {
            PatternParameter patternParameter = (PatternParameter)selectItem;
            this.type = patternParameter.getType();
            this.setValue((ModelElement)patternParameter);
        }
    }

    private void setValue(ModelElement selection) {
        this.name = selection.getName();
        this.typeName = ParametersTableLabelProvider.getType(this.type);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        VariablesEditDialog.createLabel(dialogArea, Messages.ParametersEditDialog_Name);
        this.nameText = new Text(dialogArea, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.setText(this.name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesEditDialog.this.name = VariablesEditDialog.this.nameText.getText();
            }
        });
        VariablesEditDialog.createLabel(dialogArea, Messages.ParametersEditDialog_Type);
        this.typeText = new Text(dialogArea, 2056);
        gd = new GridData(768);
        this.typeText.setLayoutData((Object)gd);
        this.typeText.setText(this.typeName);
        this.typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesEditDialog.this.typeName = VariablesEditDialog.this.typeText.getText();
            }
        });
        Button typeButton = new Button(dialogArea, 8);
        gd = new GridData();
        typeButton.setLayoutData((Object)gd);
        typeButton.setText(Messages.ParametersEditDialog_Browse);
        typeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OpenTypeWizard wizard = new OpenTypeWizard(VariablesEditDialog.this.editingDomain, VariablesEditDialog.this.type);
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int returnValue = dialog.open();
                if (returnValue == 0) {
                    Object selectType = wizard.getSelectType();
                    if (selectType instanceof String) {
                        if (selectType != null && !"".equals(selectType)) {
                            VariablesEditDialog.this.type = (String)selectType;
                            VariablesEditDialog.this.typeText.setText(ParametersTableLabelProvider.getType(VariablesEditDialog.this.type));
                        }
                    } else if (selectType instanceof BinaryType && selectType != null) {
                        VariablesEditDialog.this.type = ((BinaryType)selectType).getFullyQualifiedName();
                        VariablesEditDialog.this.typeText.setText(((BinaryType)selectType).getElementName());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return dialogArea;
    }

    public static Label createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        label.setText(content);
        return label;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    protected void computeResult() {
    }
}

