/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.manifest.ManifestChangeCommandFactory;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommand;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class FcoreGeneratorHelper {
    public static void addFolderIn(String pluginId_p, String folderName_p, boolean updateBuildProperties_p, IProgressMonitor monitor_p) {
        IProject project = ProjectHelper.getProject((String)pluginId_p);
        IFolder folder = ProjectHelper.createFolder((String)folderName_p, (IProject)project, (IProgressMonitor)monitor_p);
        if (folder != null && updateBuildProperties_p) {
            WorkspaceBuildModel buildModel = FcoreGeneratorHelper.getBuildModel(project);
            FcoreGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, String.valueOf(folderName_p) + '/');
            buildModel.save();
        }
    }

    public static void addEntryInBinaryBuild(IBuildModel buildModel_p, String entryName_p) {
        IBuild build = buildModel_p.getBuild();
        IBuildEntry binEntry = build.getEntry("bin.includes");
        if (binEntry != null) {
            try {
                if (!binEntry.contains(entryName_p)) {
                    binEntry.addToken(entryName_p);
                }
            }
            catch (CoreException ce) {
                EGFPDEPlugin.getDefault().logError(new String("FcoreGeneratorHelper.addEntryInBinInclude(..) _ ").toString(), ce);
            }
        }
    }

    public static WorkspaceBuildModel getBuildModel(IProject project_p) {
        WorkspaceBuildModel buildModel = null;
        if (project_p == null) {
            return buildModel;
        }
        IFile buildFile = project_p.getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel;
    }

    public static void addStandardFcoreDependency(String pluginId_p, boolean optional_p) {
        IPluginChangesCommand commandsOnManifest = ManifestChangeCommandFactory.setRequiredPlugins(FcoreGeneratorHelper.getEGFCoreDependency(), optional_p);
        EGFPDEPlugin.getPluginChangesCommandRunner().performChangesOnManifest(pluginId_p, Collections.singletonList(commandsOnManifest));
    }

    public static String[] getEGFCoreDependency() {
        return new String[]{EGFCorePlugin.getDefault().getPluginID()};
    }
}

