/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ParametersTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof PatternParameter) {
            PatternParameter patternParameter = (PatternParameter)element;
            switch (columnIndex) {
                case 0: {
                    return patternParameter.getName();
                }
                case 1: {
                    return ParametersTableLabelProvider.getType(patternParameter.getType());
                }
                case 2: {
                    Query query = patternParameter.getQuery();
                    if (query != null) {
                        String queryKindName;
                        String extensionId = query.getExtensionId();
                        QueryKind queryKind = IQuery.INSTANCE.getQueryKind(extensionId);
                        String string = queryKindName = queryKind == null ? null : queryKind.getName();
                        if (queryKindName != null) {
                            return queryKindName;
                        }
                        return extensionId == null ? "" : extensionId;
                    }
                    return "";
                }
            }
        } else if (element instanceof PatternVariable) {
            PatternVariable patternVariable = (PatternVariable)element;
            switch (columnIndex) {
                case 0: {
                    return patternVariable.getName();
                }
                case 1: {
                    return ParametersTableLabelProvider.getType(patternVariable.getType());
                }
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String getType(String type) {
        int mark3;
        int mark3Index;
        int mark2Index;
        if (type == null || type.length() == 0) {
            return "";
        }
        int mark1Index = type.lastIndexOf("$");
        int index = ParametersTableLabelProvider.getIndex(mark1Index, mark2Index = type.lastIndexOf("."), mark3Index = (mark3 = type.lastIndexOf("//")) == -1 ? -1 : mark3 + 1);
        if (index != -1) {
            return type.substring(index + 1);
        }
        return type;
    }

    private static int getIndex(int mark1Index, int mark2Index, int mark3Index) {
        if (mark1Index > 0) {
            return mark1Index;
        }
        if (mark3Index > 0) {
            return mark3Index;
        }
        return mark2Index;
    }
}

