/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fx.core.KeyValueStore;
import org.eclipse.fx.core.RankedService;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class OSGiUtil {
    OSGiUtil() {
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        ArrayList cl = new ArrayList();
        if (requestor != null) {
            cl.add(requestor);
        }
        cl.add(serviceClass);
        BundleContext ctx = OSGiUtil.getContext(cl);
        try {
            ServiceReference[] serviceReferences = ctx.getServiceReferences(serviceClass.getName(), null);
            if (serviceReferences == null) {
                return Collections.emptyList();
            }
            return Stream.of(serviceReferences).map(r -> new CompareableService<Object>((ServiceReference<Object>)r, ctx.getService(r))).sorted().map(s -> s.instance).collect(Collectors.toList());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static BundleContext getContext(List<Class<?>> classList) {
        for (Class<?> cl : classList) {
            Bundle b = FrameworkUtil.getBundle(cl);
            BundleContext ctx = null;
            if (b == null || (ctx = b.getBundleContext()) == null) continue;
            return ctx;
        }
        Bundle b = FrameworkUtil.getBundle(OSGiUtil.class);
        BundleContext ctx = null;
        if (b != null) {
            ctx = b.getBundleContext();
        }
        if (ctx == null) {
            throw new IllegalStateException("Unable to get a bundle context");
        }
        return ctx;
    }

    public static <S> List<ServiceUtils.ServiceReference<S>> lookupServiceReferenceList(Class<?> requestor, Class<S> serviceClass) {
        ArrayList cl = new ArrayList();
        if (requestor != null) {
            cl.add(requestor);
        }
        cl.add(serviceClass);
        BundleContext ctx = OSGiUtil.getContext(cl);
        try {
            ServiceReference[] serviceReferences = ctx.getServiceReferences(serviceClass.getName(), null);
            if (serviceReferences == null) {
                return Collections.emptyList();
            }
            List<ServiceUtils.ServiceReference<S>> list = Stream.of(serviceReferences).map(r -> new ServiceReferenceImpl(r, ctx)).sorted().collect(Collectors.toList());
            Collections.reverse(list);
            return list;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    static class CompareableService<@NonNull S>
    implements Comparable<CompareableService<S>> {
        private final ServiceReference<S> r;
        final S instance;

        public CompareableService(ServiceReference<S> r, S instance) {
            this.r = r;
            this.instance = instance;
        }

        private static int getRanking(ServiceReference<?> r) {
            Object v = r.getProperty("service.ranking");
            if (v instanceof Integer) {
                return (Integer)v;
            }
            return 0;
        }

        @Override
        public int compareTo(CompareableService<S> o) {
            int i2;
            int i1;
            if (this.instance instanceof RankedService && o.instance instanceof RankedService) {
                i1 = ((RankedService)this.instance).getRanking();
                i2 = ((RankedService)o.instance).getRanking();
            } else {
                i1 = CompareableService.getRanking(this.r);
                i2 = CompareableService.getRanking(o.r);
            }
            return -1 * Integer.compare(i1, i2);
        }
    }

    static class ServiceReferenceImpl<S>
    implements ServiceUtils.ServiceReference<S> {
        private final ServiceReference<S> ref;
        private final BundleContext ctx;
        private S serviceInstance;
        private KeyValueStore<String, Object> properties;

        public ServiceReferenceImpl(ServiceReference<S> ref, BundleContext ctx) {
            this.ref = ref;
            this.ctx = ctx;
        }

        @Override
        public S get() {
            if (this.serviceInstance == null) {
                this.serviceInstance = this.ctx.getService(this.ref);
            }
            return this.serviceInstance;
        }

        @Override
        public int getRanking() {
            Object ranking = this.ref.getProperty("service.ranking");
            return ranking == null ? 0 : (ranking instanceof Integer ? (Integer)ranking : Integer.parseInt(ranking.toString()));
        }

        @Override
        public KeyValueStore<String, Object> getProperties() {
            if (this.properties == null) {
                HashMap<String, Object> p = new HashMap<String, Object>();
                String[] stringArray = this.ref.getPropertyKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    p.put(s, this.ref.getProperty(s));
                    ++n2;
                }
                this.properties = KeyValueStore.fromMap(p);
            }
            return this.properties;
        }
    }
}

