/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;

public abstract class AbstractTypeReferenceVisitor<Result>
implements ITypeReferenceVisitor<Result> {
    @Override
    public Result visit(JvmTypeReference reference) {
        if (reference == null) {
            Result result = this.handleNullReference();
            return result;
        }
        Object result = reference.accept(this);
        return result;
    }

    protected Result handleNullReference() {
        throw new NullPointerException("Given type reference was null");
    }

    @Override
    public Result doVisitDelegateTypeReference(JvmDelegateTypeReference reference) {
        Result result = this.visit(reference.getDelegate());
        return result;
    }

    @Override
    public Result doVisitSpecializedTypeReference(JvmSpecializedTypeReference reference) {
        Result result = this.visit(reference.getEquivalent());
        return result;
    }

    public static class InheritanceAware<Result>
    extends AbstractTypeReferenceVisitor<Result> {
        @Override
        public Result doVisitTypeReference(JvmTypeReference reference) {
            throw new IllegalStateException("doVisitTypeReference was invoked but not implemented for: " + reference);
        }

        @Override
        public Result doVisitAnyTypeReference(JvmAnyTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }

        @Override
        public Result doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }

        @Override
        public Result doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }

        @Override
        public Result doVisitInnerTypeReference(JvmInnerTypeReference reference) {
            return this.doVisitParameterizedTypeReference(reference);
        }

        @Override
        public Result doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }

        @Override
        public Result doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }

        @Override
        public Result doVisitMultiTypeReference(JvmMultiTypeReference reference) {
            return this.doVisitCompoundTypeReference(reference);
        }

        @Override
        public Result doVisitSynonymTypeReference(JvmSynonymTypeReference reference) {
            return this.doVisitCompoundTypeReference(reference);
        }

        @Override
        public Result doVisitUnknownTypeReference(JvmUnknownTypeReference reference) {
            return this.doVisitTypeReference(reference);
        }
    }
}

