/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.PreferenceManager;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.core.net";
    private static Activator instance;
    private static ServiceTracker<FrameworkLog, FrameworkLog> logTracker;
    private static final String PROP_REGISTER_SERVICE = "org.eclipse.net.core.enableProxyService";
    public static final String PT_AUTHENTICATOR = "authenticator";
    private BundleContext bundleContext;
    private ServiceTracker<?, ?> instanceLocationTracker;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private ServiceRegistration<IProxyService> proxyService;
    private PreferenceManager preferenceManger;

    public Activator() {
        instance = this;
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(int severity, String message, Throwable throwable) {
        Activator.getInstance().log((IStatus)new Status(severity, ID, 0, message, throwable));
    }

    public static void logError(String message, Throwable exc) {
        Activator.getInstance().log((IStatus)new Status(4, ID, 0, message, exc));
    }

    public static void logInfo(String message, Throwable exc) {
        Activator.getInstance().log((IStatus)new Status(1, ID, 0, message, exc));
    }

    private void log(IStatus status) {
        FrameworkLog log;
        if (logTracker == null) {
            logTracker = new ServiceTracker(this.bundleContext, FrameworkLog.class, null);
            logTracker.open();
        }
        if ((log = (FrameworkLog)logTracker.getService()) != null) {
            log.log(this.getLog(status));
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    private FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(this.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                childlist.add(this.getLog(children[i]));
                ++i;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public PreferenceManager getPreferenceManager() {
        return this.preferenceManger;
    }

    public boolean instanceLocationAvailable() {
        Location instanceLocation = (Location)this.instanceLocationTracker.getService();
        return instanceLocation != null && instanceLocation.isSet();
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.preferenceManger = PreferenceManager.createConfigurationManager(ID);
        Filter filter = null;
        try {
            filter = context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocationTracker = new ServiceTracker(context, filter, null);
        this.instanceLocationTracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.DEBUG_OPTIONS_LISTENER, properties);
        if (Boolean.valueOf(System.getProperty(PROP_REGISTER_SERVICE, "true")).booleanValue()) {
            ProxyManager proxyManager = (ProxyManager)ProxyManager.getProxyManager();
            proxyManager.initialize();
            this.proxyService = context.registerService(IProxyService.class, (Object)proxyManager, new Hashtable());
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.proxyService != null) {
            this.proxyService.unregister();
            this.proxyService = null;
        }
        if (this.debugRegistration != null) {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }
}

