/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.ClassLoaderFinder;
import com.sun.webui.jsf.util.MessageUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public final class ResourceBundleManager {
    private static final ResourceBundleManager INSTANCE = new ResourceBundleManager();
    private Map<String, ResourceBundle> cache = new HashMap<String, ResourceBundle>();

    private ResourceBundleManager() {
    }

    public static ResourceBundleManager getInstance() {
        return INSTANCE;
    }

    private ResourceBundle getCachedBundle(String baseName, Locale locale) {
        return this.cache.get(this.getCacheKey(baseName, locale));
    }

    private String getCacheKey(String baseName, Locale locale) {
        return baseName + "__" + locale.toString();
    }

    private void addCachedBundle(String baseName, Locale locale, ResourceBundle bundle) {
        HashMap<String, ResourceBundle> map = new HashMap<String, ResourceBundle>(this.cache);
        map.put(this.getCacheKey(baseName, locale), bundle);
        this.cache = map;
    }

    public ResourceBundle getBundle(String baseName, Locale locale) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null && (bundle = ResourceBundle.getBundle(baseName, locale, ClassLoaderFinder.getCurrentLoader(MessageUtil.class))) != null) {
            this.addCachedBundle(baseName, locale, bundle);
        }
        return bundle;
    }

    public ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null && (bundle = ResourceBundle.getBundle(baseName, locale, loader)) != null) {
            this.addCachedBundle(baseName, locale, bundle);
        }
        return bundle;
    }
}

