/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;

abstract class RbCbRendererBase
extends AbstractRenderer {
    protected static final int INPUT = 0;
    protected static final int INPUT_DIS = 1;
    protected static final int LABEL = 2;
    protected static final int LABEL_DIS = 3;
    protected static final int IMAGE = 4;
    protected static final int IMAGE_DIS = 5;
    protected static final int SPAN = 6;
    protected static final int SPAN_DIS = 7;
    private static final String INPUT_ELEM = "input";
    private static final String SPAN_ELEM = "span";
    private static final String CHECKED_ATTR = "checked";
    private static final String DISABLED_ATTR = "disabled";
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String READONLY_ATTR = "readonly";
    private static final String READONLY_CC_ATTR = "readOnly";
    private static final String STYLE_ATTR = "style";
    private static final String STYLECLASS_ATTR = "styleClass";
    private static final String TABINDEX_ATTR = "tabindex";
    private static final String TABINDEX_CC_ATTR = "tabIndex";
    private static final String TITLE_ATTR = "title";
    private static final String TOOLTIP_ATTR = "toolTip";
    private static final String TYPE_ATTR = "type";
    private static final String VALUE_ATTR = "value";
    private static final String SPAN_SUFFIX = "_span";
    public static final String[] RBCB_EVENTS_ATTRIBUTES = new String[]{"onFocus", "onBlur", "onClick", "onDblClick", "onChange", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp"};

    RbCbRendererBase() {
    }

    protected abstract String getStyle(Theme var1, int var2);

    protected abstract boolean isSelected(FacesContext var1, UIComponent var2);

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderSelection(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String type) throws IOException {
        writer.startElement(SPAN_ELEM, component);
        writer.writeAttribute(ID_ATTR, (Object)component.getClientId(context).concat(SPAN_SUFFIX), null);
        String prop = ((RbCbSelector)component).getStyle();
        if (prop != null) {
            writer.writeAttribute(STYLE_ATTR, (Object)prop, STYLE_ATTR);
        }
        String styleClass = ((RbCbSelector)component).isDisabled() ? this.getStyle(theme, 7) : this.getStyle(theme, 6);
        if ((styleClass = RenderingUtilities.getStyleClasses(context, component, styleClass)) != null) {
            writer.writeAttribute(CLASS_ATTR, (Object)styleClass, null);
        }
        this.renderInput(context, component, theme, writer, type);
        this.renderImage(context, component, theme, writer);
        this.renderLabel(context, component, theme, writer);
        writer.endElement(SPAN_ELEM);
    }

    protected void renderInput(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String type) throws IOException {
        RbCbSelector rbcbSelector = (RbCbSelector)component;
        String componentId = component.getClientId(context);
        writer.startElement(INPUT_ELEM, component);
        writer.writeAttribute(TYPE_ATTR, (Object)type, null);
        writer.writeAttribute(ID_ATTR, (Object)componentId, ID_ATTR);
        boolean inGroup = true;
        String prop = rbcbSelector.getName();
        if (prop == null) {
            prop = componentId;
            inGroup = false;
        }
        writer.writeAttribute(NAME_ATTR, (Object)prop, NAME_ATTR);
        Object selectedValue = rbcbSelector.getSelectedValue();
        prop = ConversionUtilities.convertValueToString(component, selectedValue);
        String[] subValue = (String[])rbcbSelector.getSubmittedValue();
        if (subValue == null) {
            Object selected = rbcbSelector.getSelected();
            if (this.isSelected(context, component)) {
                writer.writeAttribute(CHECKED_ATTR, (Object)CHECKED_ATTR, null);
            }
            ConversionUtilities.setRenderedValue(component, selected);
        } else if (subValue.length != 0 && subValue[0].length() != 0 && prop != null && prop.equals(subValue[0])) {
            writer.writeAttribute(CHECKED_ATTR, (Object)CHECKED_ATTR, null);
        }
        if (inGroup && selectedValue instanceof Boolean) {
            prop = componentId;
        }
        writer.writeAttribute(VALUE_ATTR, (Object)prop, null);
        boolean readonly = rbcbSelector.isReadOnly();
        if (readonly) {
            writer.writeAttribute(READONLY_ATTR, (Object)READONLY_ATTR, READONLY_CC_ATTR);
        }
        String styleClass = null;
        boolean disabled = rbcbSelector.isDisabled();
        if (disabled) {
            writer.writeAttribute(DISABLED_ATTR, (Object)DISABLED_ATTR, DISABLED_ATTR);
            styleClass = this.getStyle(theme, 1);
        } else {
            styleClass = this.getStyle(theme, 0);
        }
        prop = rbcbSelector.getToolTip();
        if (prop != null) {
            writer.writeAttribute(TITLE_ATTR, (Object)prop, TOOLTIP_ATTR);
        }
        RbCbRendererBase.addStringAttributes(context, component, writer, RBCB_EVENTS_ATTRIBUTES);
        int tabIndex = rbcbSelector.getTabIndex();
        if (tabIndex > 0 && tabIndex < Short.MAX_VALUE) {
            writer.writeAttribute(TABINDEX_ATTR, (Object)String.valueOf(tabIndex), TABINDEX_CC_ATTR);
        }
        writer.endElement(INPUT_ELEM);
    }

    protected void renderImage(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent imageComponent = this.getImageComponent(context, component, theme);
        if (imageComponent != null) {
            RenderingUtilities.renderComponent(imageComponent, context);
        }
    }

    private UIComponent getImageComponent(FacesContext context, UIComponent component, Theme theme) throws IOException {
        RbCbSelector rbcbComponent = (RbCbSelector)component;
        ImageComponent imageComponent = (ImageComponent)rbcbComponent.getImageComponent();
        if (imageComponent == null) {
            return null;
        }
        String styleClass = rbcbComponent.isDisabled() ? this.getStyle(theme, 5) : this.getStyle(theme, 4);
        if ((styleClass = RenderingUtilities.getStyleClasses(context, (UIComponent)imageComponent, styleClass)) != null) {
            imageComponent.setStyleClass(styleClass);
        }
        return imageComponent;
    }

    protected void renderLabel(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent labelComponent = this.getLabelComponent(context, component, theme);
        if (labelComponent != null) {
            RenderingUtilities.renderComponent(labelComponent, context);
        }
    }

    private UIComponent getLabelComponent(FacesContext context, UIComponent component, Theme theme) throws IOException {
        RbCbSelector rbcbComponent = (RbCbSelector)component;
        Label labelComponent = (Label)rbcbComponent.getLabelComponent();
        if (labelComponent == null) {
            return null;
        }
        String styleClass = rbcbComponent.isDisabled() ? this.getStyle(theme, 3) : this.getStyle(theme, 2);
        if ((styleClass = RenderingUtilities.getStyleClasses(context, (UIComponent)labelComponent, styleClass)) != null) {
            labelComponent.setStyleClass(styleClass);
        }
        return labelComponent;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return ((RbCbSelector)component).getConvertedValue(context, (RbCbSelector)component, submittedValue);
    }
}

