/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.FactoryFinder;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import java.util.HashMap;

public final class TableSelectPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 6955269103244653901L;
    private Object unselected = null;
    private final HashMap<String, Object> selected = new HashMap();
    private boolean keepSelected = false;

    public TableSelectPhaseListener() {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener((PhaseListener)this);
    }

    public TableSelectPhaseListener(boolean newKeepSelected) {
        this();
        this.keepSelected(newKeepSelected);
    }

    public TableSelectPhaseListener(Object newUnselected) {
        this();
        this.unselected = newUnselected;
    }

    public void afterPhase(PhaseEvent event) {
        if (!this.keepSelected) {
            this.selected.clear();
        } else {
            TableSelectPhaseListener.log("afterPhase", "Selected values not cleared, keepSelected is false");
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void clear() {
        this.selected.clear();
    }

    public Object getSelected(RowKey rowKey) {
        if (rowKey != null) {
            return this.selected.get(rowKey.getRowId());
        }
        return this.unselected;
    }

    public boolean isKeepSelected() {
        return this.keepSelected;
    }

    public boolean isSelected(RowKey rowKey) {
        Object object = this.getSelected(rowKey);
        return object != null && object != this.unselected;
    }

    public void keepSelected(boolean newKeepSelected) {
        this.keepSelected = newKeepSelected;
    }

    public void setSelected(RowKey rowKey, Object object) {
        if (rowKey != null) {
            this.selected.put(rowKey.getRowId(), object);
        }
    }

    private static void log(String method, String message) {
        Class<TableSelectPhaseListener> clazz = TableSelectPhaseListener.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

