/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.custom.factory;

import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class URLObjectFactory
implements Serializable,
ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> refAddrs = ref.getAll();
        String protocol = null;
        String host = null;
        int port = -1;
        String file = null;
        String spec = null;
        while (refAddrs.hasMoreElements()) {
            RefAddr addr = refAddrs.nextElement();
            String type = addr.getType();
            String content = (String)addr.getContent();
            if (type.equalsIgnoreCase("protocol")) {
                protocol = content;
                continue;
            }
            if (type.equalsIgnoreCase("host")) {
                host = content;
                continue;
            }
            if (type.equalsIgnoreCase("port")) {
                try {
                    port = Integer.parseInt(content);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Provided port number is not a number: " + content, nfe);
                }
            }
            if (type.equalsIgnoreCase("file")) {
                file = content;
                continue;
            }
            if (!type.equalsIgnoreCase("spec")) continue;
            spec = content;
        }
        if (protocol != null && host != null && port != -1 && file != null) {
            return new URL(protocol, host, port, file);
        }
        if (protocol != null && host != null && file != null) {
            return new URL(protocol, host, file);
        }
        if (spec != null) {
            return new URL(spec);
        }
        throw new IllegalArgumentException("URLObjectFactory does not have necessary parameters for URL construction");
    }
}

