/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassPathEntry;

final class DirClassPathEntry
extends ClassPathEntry {
    private final File dir;
    private final Hashtable<String, String[]> subdirs = new Hashtable(29);

    DirClassPathEntry(File dir) {
        this.dir = dir;
    }

    private String[] getFiles(String subdir) {
        String[] files = this.subdirs.get(subdir);
        if (files == null) {
            files = this.computeFiles(subdir);
            this.subdirs.put(subdir, files);
        }
        return files;
    }

    private String[] computeFiles(String subdir) {
        String[] files;
        File sd = new File(this.dir.getPath(), subdir);
        if (sd.isDirectory()) {
            files = sd.list();
            if (files == null) {
                files = new String[]{};
            }
            if (files.length == 0) {
                String[] nonEmpty = new String[]{""};
                files = nonEmpty;
            }
        } else {
            files = new String[]{};
        }
        return files;
    }

    @Override
    ClassFile getFile(String name, String subdir, String basename, boolean isDirectory) {
        File file = new File(this.dir.getPath(), name);
        String[] list = this.getFiles(subdir);
        if (isDirectory) {
            if (list.length > 0) {
                return ClassFile.newClassFile(file);
            }
        } else {
            for (int j = 0; j < list.length; ++j) {
                if (!basename.equals(list[j])) continue;
                return ClassFile.newClassFile(file);
            }
        }
        return null;
    }

    @Override
    void fillFiles(String pkg, String ext, Hashtable<String, ClassFile> files) {
        String[] list = this.getFiles(pkg);
        for (int j = 0; j < list.length; ++j) {
            Object name = list[j];
            if (!((String)name).endsWith(ext)) continue;
            name = pkg + File.separatorChar + (String)name;
            File file = new File(this.dir.getPath(), (String)name);
            files.put((String)name, ClassFile.newClassFile(file));
        }
    }

    @Override
    void close() throws IOException {
    }
}

