/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.runtime.impl;

import com.sun.messaging.jmq.jmsclient.runtime.impl.DirectBrokerInstance;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import com.sun.messaging.jmq.jmsservice.JMSDirectBroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import jakarta.jms.JMSException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class BrokerInstanceImpl
implements DirectBrokerInstance {
    private static final String BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.BrokerProcess";
    private static final String DIRECT_BROKER_PROCESS2 = "com.sun.messaging.jmq.jmsserver.DualThreadDBP";
    private static final String DIRECT_BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.DirectBrokerProcess";
    private BrokerEventListener evlistener = null;
    private Properties props = null;
    private JMSBroker bkr = null;
    private boolean running = false;
    private boolean isShutdown = false;
    private static BrokerInstanceImpl soleInstance;
    private static boolean isDirect;
    public static volatile boolean isTwoThread;
    public static volatile boolean isTwoThreadSyncReplies;

    protected BrokerInstanceImpl() {
    }

    public static BrokerInstanceImpl getInstance() {
        return soleInstance;
    }

    public static synchronized BrokerInstanceImpl createInstance() throws IllegalAccessException {
        if (soleInstance == null) {
            soleInstance = new BrokerInstanceImpl();
        } else if (soleInstance.isShutdown()) {
            soleInstance = new BrokerInstanceImpl();
        } else {
            throw new IllegalAccessException("Cannot create broker instance.  A broker instance is already created.");
        }
        return soleInstance;
    }

    @Override
    public BrokerEventListener getBrokerEventListener() {
        return this.evlistener;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public synchronized void init(Properties props, BrokerEventListener evlistener) {
        this.props = props;
        this.evlistener = evlistener;
        if (this.running) {
            throw new IllegalStateException("Cannot initialize while broker is in running state.");
        }
        try {
            this.getBroker();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addStartupMessages();
    }

    @Override
    public Properties parseArgs(String[] args) {
        this.getBroker();
        return this.bkr.parseArgs(args);
    }

    @Override
    public void shutdown() {
        this.bkr.stop(true);
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown || this.bkr != null && this.bkr.isShutdown();
    }

    public void setShutdown(boolean isShutdown) {
        this.isShutdown = isShutdown;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        RuntimeException failStartEx = new RuntimeException("Broker failed to start");
        try {
            if (this.bkr.start(true, this.props, this.evlistener, false, failStartEx) != 0) {
                throw failStartEx;
            }
            this.running = true;
        }
        catch (Exception e) {
            if (e == failStartEx) {
                throw failStartEx;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.bkr.stop(false);
        this.running = false;
    }

    @Override
    public synchronized boolean isBrokerRunning() {
        return this.running;
    }

    @Override
    public boolean isDirectMode() {
        return isDirect;
    }

    @Override
    public DirectBrokerConnection createDirectConnection() throws JMSException {
        DirectBrokerConnection dbc = null;
        if (isDirect) {
            dbc = ((JMSDirectBroker)this.bkr).getConnection();
        }
        return dbc;
    }

    private synchronized void getBroker() {
        try {
            if (this.bkr == null) {
                this.bkr = isDirect ? (isTwoThread ? (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) : (JMSBroker)Class.forName(BROKER_PROCESS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addStartupMessages() {
        if (!isDirect) {
            this.bkr.addEmbeddedBrokerStartupMessage("Embedded broker: non-default value used for imq.embed.broker.direct.disabled=" + isDirect);
        }
        if (!isTwoThread) {
            this.bkr.addEmbeddedBrokerStartupMessage("Embedded broker: non-default value used for imq.embed.broker.direct.twothread=" + isTwoThread);
        }
        if (!isTwoThreadSyncReplies) {
            this.bkr.addEmbeddedBrokerStartupMessage("Embedded broker: non-default value used for imq.embed.broker.direct.twothread.syncreplies=" + isTwoThreadSyncReplies);
        }
    }

    @Override
    public JMSService getJMSService() {
        String DEFAULT_DIRECTMODE_SERVICE_NAME = "jmsdirect";
        JMSService jmsService = this.getJMSService(DEFAULT_DIRECTMODE_SERVICE_NAME);
        if (jmsService != null) {
            return jmsService;
        }
        List serviceNames = ServiceManager.getAllServiceNames();
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            jmsService = this.getJMSService((String)iter.next());
            if (jmsService == null) continue;
            return jmsService;
        }
        return null;
    }

    private JMSService getJMSService(String serviceName) {
        ServiceManager sm = Globals.getServiceManager();
        if (sm == null) {
            return null;
        }
        Service svc = sm.getService(serviceName);
        if (svc == null) {
            return null;
        }
        if (!(svc instanceof IMQService)) {
            return null;
        }
        IMQService imqSvc = (IMQService)svc;
        if (!imqSvc.isDirect()) {
            return null;
        }
        if (!(imqSvc instanceof IMQDirectService)) {
            return null;
        }
        IMQDirectService imqDirectSvc = (IMQDirectService)imqSvc;
        return imqDirectSvc.getJMSService();
    }

    @Override
    public void addEmbeddedBrokerStartupMessage(String embeddedBrokerStartupMessage) {
        this.bkr.addEmbeddedBrokerStartupMessage(embeddedBrokerStartupMessage);
    }

    static {
        isDirect = true;
        isTwoThread = true;
        isTwoThreadSyncReplies = true;
        boolean tmp = Boolean.getBoolean("imq.embed.broker.direct.disabled");
        if (tmp) {
            isDirect = false;
        }
        isTwoThread = Boolean.valueOf(System.getProperty("imq.embed.broker.direct.twothread", "true"));
        isTwoThreadSyncReplies = Boolean.valueOf(System.getProperty("imq.embed.broker.direct.twothread.syncreplies", "true"));
        Globals.setAPIDirectTwoThreadSyncReplies(isTwoThreadSyncReplies);
    }
}

