/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.mgmt.ClusterManager;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MessageEvent;
import org.glassfish.shoal.gms.mgmt.transport.MessageIOException;
import org.glassfish.shoal.gms.mgmt.transport.MessageImpl;
import org.glassfish.shoal.gms.mgmt.transport.MessageListener;
import org.glassfish.shoal.gms.mgmt.transport.MessageSender;
import org.glassfish.shoal.gms.mgmt.transport.MulticastMessageSender;

public class LWRMulticast
implements MessageListener {
    private static final Logger LOG = Logger.getLogger(LWRMulticast.class.getName());
    public static final String ACKTAG = "ACK";
    public static final String SEQTAG = "SEQ";
    public static final String SRCIDTAG = "SRCID";
    private boolean closed = false;
    private boolean bound = false;
    private long padding = 250L;
    private long timeout = 5000L + this.padding;
    private AtomicLong sequence = new AtomicLong();
    private final Object ackLock = new Object();
    private int threshold = 0;
    private Set<PeerID> ackSet = new HashSet<PeerID>();
    private Set<PeerID> ackList = new HashSet<PeerID>();
    private long t0 = System.currentTimeMillis();
    private ClusterManager manager;
    private PeerID localPeerID;
    protected MessageListener msgListener;

    public LWRMulticast(ClusterManager manager, MessageListener msgListener) throws IOException {
        this.joinGroup(manager, msgListener);
    }

    public void joinGroup(ClusterManager manager, MessageListener msgListener) throws IOException {
        if (msgListener == null) {
            throw new IllegalArgumentException("msgListener can not be null");
        }
        this.manager = manager;
        this.localPeerID = manager.getPeerID();
        this.msgListener = msgListener;
        LOG.log(Level.FINEST, "Statring LWRMulticast on local peer id :" + String.valueOf(this.localPeerID));
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.bound = false;
        this.closed = true;
    }

    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        block9: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            PeerID id = LWRMulticast.getSource(message);
            if (id != null && id.equals(this.localPeerID)) {
                return;
            }
            Object element = message.getMessageElement(ACKTAG);
            if (element instanceof Long) {
                this.processAck(id, (Long)element);
            } else {
                element = message.getMessageElement(SEQTAG);
                if (element instanceof Long) {
                    this.ackMessage(id, (Long)element);
                    try {
                        if (this.msgListener != null) {
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.log(Level.FINEST, "Calling message listener");
                            }
                            this.msgListener.receiveMessageEvent(event);
                        }
                    }
                    catch (Throwable th) {
                        if (!LOG.isLoggable(Level.FINEST)) break block9;
                        LOG.log(Level.FINEST, "Exception occurred while calling message listener", th);
                    }
                }
            }
        }
    }

    @Override
    public int getType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(PeerID id, long seq) {
        LOG.log(Level.FINEST, "Processing ack for message sequence " + seq);
        if (!this.ackSet.contains(id)) {
            this.ackSet.add(id);
            if (this.ackSet.size() >= this.threshold) {
                Object object = this.ackLock;
                synchronized (object) {
                    this.ackLock.notifyAll();
                }
            }
        }
    }

    private void ackMessage(PeerID id, long seq) {
        block2: {
            LOG.log(Level.FINEST, "Ack'ing message Sequence :" + seq);
            MessageImpl msg = new MessageImpl(4);
            msg.addMessageElement(SRCIDTAG, this.localPeerID);
            msg.addMessageElement(ACKTAG, Long.valueOf(seq));
            try {
                this.send(id, (Message)msg);
            }
            catch (IOException io) {
                if (!LOG.isLoggable(Level.FINEST)) break block2;
                LOG.log(Level.FINEST, "I/O Error occured " + io.toString());
            }
        }
    }

    public Set<PeerID> getAckList() {
        return this.ackList;
    }

    public synchronized long getSoTimeout() {
        return this.timeout;
    }

    public synchronized void setSoTimeout(long timeout) throws IOException {
        this.checkState();
        this.timeout = timeout + this.padding;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private void checkState() throws IOException {
        if (this.isClosed()) {
            throw new IOException("LWRMulticast is closed");
        }
        if (!this.isBound()) {
            throw new IOException("LWRMulticast not bound");
        }
    }

    public static long getSequenceID(Message msg) {
        Object value = msg.getMessageElement(SEQTAG);
        if (value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public static PeerID getSource(Message msg) {
        PeerID id = null;
        Object value = msg.getMessageElement(SRCIDTAG);
        if (value instanceof PeerID) {
            id = (PeerID)value;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message msg, int threshold) throws IOException {
        if (threshold < 0) {
            throw new IllegalArgumentException("Invalid threshold " + threshold + " must be >= 0");
        }
        this.t0 = System.currentTimeMillis();
        this.threshold = threshold;
        msg.addMessageElement(SRCIDTAG, this.localPeerID);
        long seq = this.sequence.getAndIncrement();
        msg.addMessageElement(SEQTAG, Long.valueOf(seq));
        Object object = this.ackLock;
        synchronized (object) {
            this.ackList.clear();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Sending message sequence #: " + seq + " Threshold :" + threshold);
            }
            this.send((PeerID)null, msg);
            if (threshold == 0) {
                return;
            }
            try {
                this.ackLock.wait(this.timeout);
                if (this.ackSet.size() >= threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    return;
                }
            }
            catch (InterruptedException ie) {
                LOG.log(Level.FINEST, "Interrupted " + ie.toString());
            }
            this.ackList = new HashSet<PeerID>(this.ackSet);
            this.ackSet.clear();
            if (this.ackList.size() < threshold) {
                throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + threshold + " received :" + this.ackList.size());
            }
        }
    }

    public boolean send(PeerID pid, Message msg) throws IOException {
        this.checkState();
        LOG.log(Level.FINEST, "Sending a message");
        if (pid != null) {
            MessageSender sender = this.manager.getNetworkManager().getMessageSender(1);
            if (sender == null) {
                throw new IOException("message sender is null");
            }
            return sender.send(pid, msg);
        }
        MulticastMessageSender sender = this.manager.getNetworkManager().getMulticastMessageSender();
        if (sender == null) {
            throw new IOException("multicast sender is null");
        }
        return sender.broadcast(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Set<PeerID> ids, Message msg) throws IOException {
        boolean sent = true;
        this.checkState();
        this.threshold = ids.size();
        this.ackList.clear();
        this.ackSet.clear();
        LOG.log(Level.FINEST, "Sending a message");
        if (!ids.isEmpty()) {
            MessageSender sender = this.manager.getNetworkManager().getMessageSender(1);
            if (sender == null) {
                throw new IOException("message sender is null");
            }
            for (PeerID peerID : ids) {
                if (sender.send(peerID, msg)) continue;
                sent = false;
            }
            if (!sent) {
                return sent;
            }
            Object object = this.ackLock;
            synchronized (object) {
                try {
                    this.ackLock.wait(this.timeout);
                    if (this.ackSet.size() >= this.threshold) {
                        this.ackList = new HashSet<PeerID>(this.ackSet);
                        this.ackSet.clear();
                        return sent;
                    }
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.FINEST, "Interrupted " + ie.toString());
                }
                if (this.ackSet.size() < this.threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + this.threshold + " received :" + this.ackSet.size());
                }
            }
        }
        return sent;
    }
}

