/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.common;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.FailureSuspectedSignal;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.common.GMSContext;
import org.glassfish.shoal.gms.common.GMSContextFactory;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public class FailureSuspectedSignalImpl
implements FailureSuspectedSignal {
    protected String failedMember = null;
    protected String groupName = null;
    protected static final String MEMBER_DETAILS = "MEMBERDETAILS";
    protected GMSContext ctx;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    protected long startTime;

    FailureSuspectedSignalImpl() {
    }

    public FailureSuspectedSignalImpl(String failedMember, String groupName, long startTime) {
        this.failedMember = failedMember;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    FailureSuspectedSignalImpl(FailureSuspectedSignal signal) {
        this.failedMember = signal.getMemberToken();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    public void acquire() throws SignalAcquireException {
        logger.log(Level.FINE, "FailureSuspectedSignal Acquired...");
    }

    public void release() throws SignalReleaseException {
        this.failedMember = null;
        logger.log(Level.FINE, "FailureSuspectedSignal Released...");
    }

    public String getMemberToken() {
        return this.failedMember;
    }

    public Map<Serializable, Serializable> getMemberDetails() {
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, this.failedMember);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

