/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.ConvertExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Vset;

public class CastExpression
extends BinaryExpression {
    public CastExpression(long where, Expression left, Expression right) {
        super(34, where, left.type, left, right);
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.type = this.left.toType(env, ctx);
        vset = this.right.checkValue(env, ctx, vset, exp);
        if (this.type.isType(13) || this.right.type.isType(13)) {
            return vset;
        }
        if (this.type.equals(this.right.type)) {
            return vset;
        }
        try {
            if (env.explicitCast(this.right.type, this.type)) {
                this.right = new ConvertExpression(this.where, this.type, this.right);
                return vset;
            }
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, opNames[this.op]);
        }
        env.error(this.where, "invalid.cast", this.right.type, this.type);
        return vset;
    }

    @Override
    public boolean isConstant() {
        if (this.type.inMask(1792) && !this.type.equals(Type.tString)) {
            return false;
        }
        return this.right.isConstant();
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        return this.right.inline(env, ctx);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        return this.right.inlineValue(env, ctx);
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (ctx == null) {
            return 1 + this.right.costInline(thresh, env, ctx);
        }
        ClassDefinition sourceClass = ctx.field.getClassDefinition();
        try {
            if (this.left.type.isType(9) || sourceClass.permitInlinedAccess(env, env.getClassDeclaration(this.left.type))) {
                return 1 + this.right.costInline(thresh, env, ctx);
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return thresh;
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        if (this.type.isType(13)) {
            this.left.print(out);
        } else {
            out.print(this.type);
        }
        out.print(" ");
        this.right.print(out);
        out.print(")");
    }
}

