/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.read.only;

import ee.jakarta.tck.data.framework.read.only.AsciiCharacter;
import ee.jakarta.tck.data.framework.read.only.AsciiCharacters;
import ee.jakarta.tck.data.framework.read.only.Populator;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class AsciiCharactersPopulator
implements Populator<AsciiCharacters> {
    public static AsciiCharactersPopulator get() {
        return new AsciiCharactersPopulator();
    }

    @Override
    public void populationLogic(AsciiCharacters repo) {
        ArrayList<AsciiCharacter> dictonary = new ArrayList<AsciiCharacter>();
        IntStream.range(1, 128).forEach(value -> {
            AsciiCharacter inst = new AsciiCharacter();
            inst.setId(value);
            inst.setNumericValue(value);
            inst.setHexadecimal(Integer.toHexString(value));
            inst.setThisCharacter((char)value);
            inst.setControl(Character.isISOControl((char)value));
            dictonary.add(inst);
        });
        repo.saveAll(dictonary);
    }

    @Override
    public boolean isPopulated(AsciiCharacters repo) {
        return repo.countByHexadecimalNotNull() == 127L;
    }
}

