/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm10;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm10.JoinColumn;
import org.jboss.shrinkwrap.descriptor.api.orm10.JoinTable;
import org.jboss.shrinkwrap.descriptor.api.orm10.UniqueConstraint;
import org.jboss.shrinkwrap.descriptor.impl.orm10.JoinColumnImpl;
import org.jboss.shrinkwrap.descriptor.impl.orm10.UniqueConstraintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableImpl<T>
implements Child<T>,
JoinTable<T> {
    private T t;
    private Node childNode;

    public JoinTableImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public JoinTableImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public JoinColumn<JoinTable<T>> getOrCreateJoinColumn() {
        List nodeList = this.childNode.get("join-column");
        if (nodeList != null && nodeList.size() > 0) {
            return new JoinColumnImpl<JoinTable<T>>(this, "join-column", this.childNode, (Node)nodeList.get(0));
        }
        return this.createJoinColumn();
    }

    public JoinColumn<JoinTable<T>> createJoinColumn() {
        return new JoinColumnImpl<JoinTable<T>>(this, "join-column", this.childNode);
    }

    public List<JoinColumn<JoinTable<T>>> getAllJoinColumn() {
        ArrayList<JoinColumn<JoinTable<T>>> list = new ArrayList<JoinColumn<JoinTable<T>>>();
        List nodeList = this.childNode.get("join-column");
        for (Node node : nodeList) {
            JoinColumnImpl<JoinTableImpl> type = new JoinColumnImpl<JoinTableImpl>(this, "join-column", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public JoinTable<T> removeAllJoinColumn() {
        this.childNode.removeChildren("join-column");
        return this;
    }

    public JoinColumn<JoinTable<T>> getOrCreateInverseJoinColumn() {
        List nodeList = this.childNode.get("inverse-join-column");
        if (nodeList != null && nodeList.size() > 0) {
            return new JoinColumnImpl<JoinTable<T>>(this, "inverse-join-column", this.childNode, (Node)nodeList.get(0));
        }
        return this.createInverseJoinColumn();
    }

    public JoinColumn<JoinTable<T>> createInverseJoinColumn() {
        return new JoinColumnImpl<JoinTable<T>>(this, "inverse-join-column", this.childNode);
    }

    public List<JoinColumn<JoinTable<T>>> getAllInverseJoinColumn() {
        ArrayList<JoinColumn<JoinTable<T>>> list = new ArrayList<JoinColumn<JoinTable<T>>>();
        List nodeList = this.childNode.get("inverse-join-column");
        for (Node node : nodeList) {
            JoinColumnImpl<JoinTableImpl> type = new JoinColumnImpl<JoinTableImpl>(this, "inverse-join-column", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public JoinTable<T> removeAllInverseJoinColumn() {
        this.childNode.removeChildren("inverse-join-column");
        return this;
    }

    public UniqueConstraint<JoinTable<T>> getOrCreateUniqueConstraint() {
        List nodeList = this.childNode.get("unique-constraint");
        if (nodeList != null && nodeList.size() > 0) {
            return new UniqueConstraintImpl<JoinTable<T>>(this, "unique-constraint", this.childNode, (Node)nodeList.get(0));
        }
        return this.createUniqueConstraint();
    }

    public UniqueConstraint<JoinTable<T>> createUniqueConstraint() {
        return new UniqueConstraintImpl<JoinTable<T>>(this, "unique-constraint", this.childNode);
    }

    public List<UniqueConstraint<JoinTable<T>>> getAllUniqueConstraint() {
        ArrayList<UniqueConstraint<JoinTable<T>>> list = new ArrayList<UniqueConstraint<JoinTable<T>>>();
        List nodeList = this.childNode.get("unique-constraint");
        for (Node node : nodeList) {
            UniqueConstraintImpl<JoinTableImpl> type = new UniqueConstraintImpl<JoinTableImpl>(this, "unique-constraint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public JoinTable<T> removeAllUniqueConstraint() {
        this.childNode.removeChildren("unique-constraint");
        return this;
    }

    public JoinTable<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public JoinTable<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    public JoinTable<T> catalog(String catalog) {
        this.childNode.attribute("catalog", catalog);
        return this;
    }

    public String getCatalog() {
        return this.childNode.getAttribute("catalog");
    }

    public JoinTable<T> removeCatalog() {
        this.childNode.removeAttribute("catalog");
        return this;
    }

    public JoinTable<T> schema(String schema) {
        this.childNode.attribute("schema", schema);
        return this;
    }

    public String getSchema() {
        return this.childNode.getAttribute("schema");
    }

    public JoinTable<T> removeSchema() {
        this.childNode.removeAttribute("schema");
        return this;
    }
}

